/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.displaysettings;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.nifty.displaysettings.DsScreen;
import jme3utilities.ui.InputMode;

public class DsInputMode
extends InputMode {
    private static final Logger logger = Logger.getLogger(DsInputMode.class.getName());
    private static final String assetPath = "Textures/cursors/default.cur";
    private final DsScreen screen;

    DsInputMode(DsScreen screen) {
        super("ds");
        Validate.nonNull((Object)((Object)screen), (String)"screen");
        this.screen = screen;
    }

    protected void defaultBindings() {
        Platform platform = JmeSystem.getPlatform();
        if (platform.getOs() == Platform.Os.Linux) {
            this.bind("ScreenShot", new int[]{70});
        } else {
            this.bind("ScreenShot", new int[]{183});
        }
        this.bind("return", new int[]{1});
        this.bind("SIMPLEAPP_HideStats", new int[]{63});
        this.bind("SIMPLEAPP_Memory", new int[]{50});
    }

    public void initialize(AppStateManager stateManager, Application application) {
        Validate.nonNull((Object)stateManager, (String)"state manager");
        AssetManager am = application.getAssetManager();
        JmeCursor cursor = (JmeCursor)am.loadAsset(assetPath);
        this.setCursor(cursor);
        super.initialize(stateManager, application);
    }

    public void onAction(String actionString, boolean ongoing, float ignored) {
        this.screen.onAction(actionString, ongoing, ignored);
    }
}

