/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.InputManager;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.niftygui.InputSystemJme;
import com.jme3.niftygui.JmeBatchRenderBackend;
import com.jme3.niftygui.RenderDeviceJme;
import com.jme3.niftygui.SoundDeviceJme;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.image.ColorSpace;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.render.batch.BatchRenderConfiguration;
import de.lessvoid.nifty.render.batch.BatchRenderDevice;
import de.lessvoid.nifty.render.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.spi.time.impl.AccurateTimeProvider;
import de.lessvoid.nifty.tools.resourceloader.ResourceLocation;
import java.io.InputStream;
import java.net.URL;

public class NiftyJmeDisplay
implements SceneProcessor {
    private boolean inited = false;
    private Nifty nifty;
    private AssetManager assetManager;
    private RenderManager renderManager;
    private InputManager inputManager;
    private RenderDeviceJme renderDev;
    private JmeBatchRenderBackend batchRendererBackend;
    private InputSystemJme inputSys;
    private SoundDeviceJme soundDev;
    private Renderer renderer;
    private ViewPort vp;
    private ResourceLocationJme resourceLocation;
    private int width;
    private int height;

    public NiftyJmeDisplay() {
    }

    public static NiftyJmeDisplay newNiftyJmeDisplay(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort viewport) {
        return NiftyJmeDisplay.newNiftyJmeDisplay(assetManager, inputManager, audioRenderer, viewport, new BatchRenderConfiguration());
    }

    public static NiftyJmeDisplay newNiftyJmeDisplay(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort viewport, BatchRenderConfiguration batchRenderConfiguration) {
        return new NiftyJmeDisplay(assetManager, inputManager, audioRenderer, viewport, batchRenderConfiguration);
    }

    @Deprecated
    public NiftyJmeDisplay(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort viewport, int atlasWidth, int atlasHeight) {
        this.initialize(assetManager, inputManager, audioRenderer, viewport);
        this.renderDev = null;
        this.batchRendererBackend = new JmeBatchRenderBackend(this);
        BatchRenderConfiguration batchRenderConfiguration = new BatchRenderConfiguration();
        batchRenderConfiguration.atlasWidth = atlasWidth;
        batchRenderConfiguration.atlasHeight = atlasHeight;
        this.nifty = new Nifty((RenderDevice)new BatchRenderDevice((BatchRenderBackend)this.batchRendererBackend, batchRenderConfiguration), (SoundDevice)this.soundDev, (InputSystem)this.inputSys, (TimeProvider)new AccurateTimeProvider());
        this.inputSys.setNifty(this.nifty);
        this.resourceLocation = new ResourceLocationJme();
        this.nifty.getResourceLoader().removeAllResourceLocations();
        this.nifty.getResourceLoader().addResourceLocation((ResourceLocation)this.resourceLocation);
    }

    private NiftyJmeDisplay(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort viewport, BatchRenderConfiguration batchRenderConfiguration) {
        this.initialize(assetManager, inputManager, audioRenderer, viewport);
        this.renderDev = null;
        this.batchRendererBackend = new JmeBatchRenderBackend(this);
        this.nifty = new Nifty((RenderDevice)new BatchRenderDevice((BatchRenderBackend)this.batchRendererBackend, batchRenderConfiguration), (SoundDevice)this.soundDev, (InputSystem)this.inputSys, (TimeProvider)new AccurateTimeProvider());
        this.inputSys.setNifty(this.nifty);
        this.resourceLocation = new ResourceLocationJme();
        this.nifty.getResourceLoader().removeAllResourceLocations();
        this.nifty.getResourceLoader().addResourceLocation((ResourceLocation)this.resourceLocation);
    }

    public NiftyJmeDisplay(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort vp) {
        this(assetManager, inputManager, audioRenderer, vp, ColorSpace.Linear);
    }

    public NiftyJmeDisplay(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort vp, ColorSpace colorSpace) {
        this.initialize(assetManager, inputManager, audioRenderer, vp);
        this.renderDev = new RenderDeviceJme(this, colorSpace);
        this.batchRendererBackend = null;
        this.nifty = new Nifty((RenderDevice)this.renderDev, (SoundDevice)this.soundDev, (InputSystem)this.inputSys, (TimeProvider)new AccurateTimeProvider());
        this.inputSys.setNifty(this.nifty);
        this.resourceLocation = new ResourceLocationJme();
        this.nifty.getResourceLoader().removeAllResourceLocations();
        this.nifty.getResourceLoader().addResourceLocation((ResourceLocation)this.resourceLocation);
    }

    private void initialize(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort viewport) {
        this.assetManager = assetManager;
        this.inputManager = inputManager;
        Camera camera = viewport.getCamera();
        this.width = camera.getWidth();
        this.height = camera.getHeight();
        this.soundDev = new SoundDeviceJme(assetManager, audioRenderer);
        this.inputSys = new InputSystemJme(inputManager);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        if (this.renderDev != null) {
            this.renderDev.setRenderManager(rm);
        } else {
            this.batchRendererBackend.setRenderManager(rm);
        }
        if (this.inputManager != null) {
            this.inputManager.addRawInputListener((RawInputListener)this.inputSys);
        }
        this.inited = true;
        this.vp = vp;
        this.renderer = rm.getRenderer();
        this.inputSys.reset();
        Camera camera = vp.getCamera();
        this.width = camera.getWidth();
        this.height = camera.getHeight();
        this.inputSys.setHeight(this.height);
    }

    public Nifty getNifty() {
        return this.nifty;
    }

    public void simulateKeyEvent(KeyInputEvent event) {
        this.inputSys.onKeyEvent(event);
    }

    AssetManager getAssetManager() {
        return this.assetManager;
    }

    RenderManager getRenderManager() {
        return this.renderManager;
    }

    int getHeight() {
        return this.height;
    }

    int getWidth() {
        return this.width;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.width = w;
        this.height = h;
        this.inputSys.setHeight(h);
        this.nifty.resolutionChanged();
    }

    public boolean isInitialized() {
        return this.inited;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
        this.renderManager.setCamera(this.vp.getCamera(), true);
        this.nifty.render(false);
        this.renderManager.setCamera(this.vp.getCamera(), false);
    }

    public void postFrame(FrameBuffer out) {
    }

    public void cleanup() {
        this.inited = false;
        this.inputSys.reset();
        if (this.inputManager != null) {
            this.inputManager.removeRawInputListener((RawInputListener)this.inputSys);
        }
    }

    public void setProfiler(AppProfiler profiler) {
    }

    protected class ResourceLocationJme
    implements ResourceLocation {
        protected ResourceLocationJme() {
        }

        public InputStream getResourceAsStream(String path) {
            AssetKey key = new AssetKey(path);
            AssetInfo info = NiftyJmeDisplay.this.assetManager.locateAsset(key);
            if (info != null) {
                return info.openStream();
            }
            throw new AssetNotFoundException(path);
        }

        public URL getResource(String path) {
            throw new UnsupportedOperationException();
        }
    }
}

