/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.asset.TextureKey;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import de.lessvoid.nifty.spi.render.RenderImage;

public class RenderImageJme
implements RenderImage {
    private final Texture2D texture;
    private final Image image;
    private final int width;
    private final int height;

    public RenderImageJme(String filename, boolean linear, NiftyJmeDisplay display) {
        TextureKey key = new TextureKey(filename, true);
        key.setAnisotropy(0);
        key.setGenerateMips(false);
        this.texture = (Texture2D)display.getAssetManager().loadTexture(key);
        this.texture.setMagFilter(linear ? Texture.MagFilter.Bilinear : Texture.MagFilter.Nearest);
        this.texture.setMinFilter(linear ? Texture.MinFilter.BilinearNoMipMaps : Texture.MinFilter.NearestNoMipMaps);
        this.image = this.texture.getImage();
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    public RenderImageJme(Texture2D texture) {
        if (texture.getImage() == null) {
            throw new IllegalArgumentException("texture.getImage() cannot be null");
        }
        this.texture = texture;
        this.image = texture.getImage();
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    public Texture2D getTexture() {
        return this.texture;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void dispose() {
    }
}

