/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.math.Vector2f;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventAnnotationProcessor;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.nifty.GuiAppState;
import jme3utilities.nifty.WindowController;
import jme3utilities.ui.InputMode;

public class BasicScreenController
extends GuiAppState
implements ScreenController {
    private static final Logger logger = Logger.getLogger(BasicScreenController.class.getName());
    private ActionListener listener = null;
    private boolean enableDuringInitialization;
    private boolean hasStarted = false;
    private final String screenId;
    private final String xmlAssetPath;
    private final List<WindowController> windowControllers = new ArrayList<WindowController>(20);

    public BasicScreenController(String screenId, String xmlAssetPath, boolean enableDuringInitialization) {
        super(InitialState.Disabled);
        Validate.nonNull((Object)screenId, (String)"screen id");
        Validate.nonNull((Object)xmlAssetPath, (String)"asset path");
        this.screenId = screenId;
        this.xmlAssetPath = xmlAssetPath;
        this.enableDuringInitialization = enableDuringInitialization;
        assert (!this.isInitialized());
        assert (!this.isEnabled());
    }

    public BasicScreenController(String screenId, String xmlAssetPath, InitialState initialState) {
        super(InitialState.Disabled);
        Validate.nonNull((Object)screenId, (String)"screen id");
        Validate.nonNull((Object)xmlAssetPath, (String)"asset path");
        this.screenId = screenId;
        this.xmlAssetPath = xmlAssetPath;
        boolean bl = this.enableDuringInitialization = initialState == InitialState.Enabled;
        assert (!this.isInitialized());
        assert (!this.isEnabled());
    }

    void addWindowController(WindowController controller) {
        this.windowControllers.add(controller);
    }

    public ActionListener getListener() {
        assert (this.listener != null);
        return this.listener;
    }

    public Screen getScreen() {
        Screen screen = this.getNifty().getScreen(this.screenId);
        assert (screen != null) : "screenId = " + MyString.quote((CharSequence)this.screenId);
        return screen;
    }

    public String getScreenId() {
        assert (this.screenId != null);
        return this.screenId;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public boolean isMouseInsideElement(String elementId) {
        Validate.nonNull((Object)elementId, (String)"element id");
        if (!this.isEnabled()) {
            return false;
        }
        Element element = this.getScreen().findElementById(elementId);
        if (element == null) {
            return false;
        }
        Vector2f mouseXY = this.inputManager.getCursorPosition();
        int mouseX = Math.round(mouseXY.x);
        int displayHeight = this.cam.getHeight();
        int mouseY = displayHeight - Math.round(mouseXY.y);
        boolean result = element.isMouseInsideElement(mouseX, mouseY);
        return result;
    }

    public Collection<WindowController> listWindowControllers() {
        int numWindows = this.windowControllers.size();
        ArrayList<WindowController> result = new ArrayList<WindowController>(numWindows);
        result.addAll(this.windowControllers);
        return result;
    }

    public void perform(String actionString) {
        Validate.nonNull((Object)actionString, (String)"action string");
        logger.log(Level.INFO, "actionString={0}", MyString.quote((CharSequence)actionString));
        BasicScreenController screen = this.getApplication().getEnabledScreen();
        ActionListener actionListener = screen.getListener();
        boolean isOngoing = true;
        float tpf = 0.0f;
        try {
            actionListener.onAction(actionString, isOngoing, tpf);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Caught unexpected throwable:", throwable);
            this.getApplication().stop(false);
        }
    }

    public void performActive(String actionString) {
        Validate.nonNull((Object)actionString, (String)"action string");
        logger.log(Level.INFO, "actionString={0}", MyString.quote((CharSequence)actionString));
        InputMode actionListener = InputMode.getActiveMode();
        boolean isOngoing = true;
        float tpf = 0.0f;
        try {
            actionListener.onAction(actionString, isOngoing, tpf);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Caught unexpected throwable:", throwable);
            this.getApplication().stop(false);
        }
    }

    public final void setListener(ActionListener newListener) {
        Validate.nonNull((Object)newListener, (String)"listener");
        this.listener = newListener;
    }

    protected void disable() {
        assert (this.isInitialized());
        assert (this.isEnabled());
        BasicScreenController enabledScreen = this.getApplication().getEnabledScreen();
        assert (enabledScreen == this) : enabledScreen;
        logger.log(Level.INFO, "screenId={0}", MyString.quote((CharSequence)this.screenId));
        NiftyJmeDisplay display = this.getApplication().getNiftyDisplay();
        this.guiViewPort.removeProcessor((SceneProcessor)display);
        NiftyEventAnnotationProcessor.unprocess((Object)((Object)this));
        this.getApplication().setEnabledScreen(null);
        super.setEnabled(false);
    }

    protected void enable() {
        assert (this.isInitialized());
        assert (!this.isEnabled());
        logger.log(Level.INFO, "screenId={0}", MyString.quote((CharSequence)this.screenId));
        NiftyJmeDisplay display = this.getApplication().getNiftyDisplay();
        this.guiViewPort.addProcessor((SceneProcessor)display);
        this.getNifty().gotoScreen(this.screenId);
        NiftyEventAnnotationProcessor.process((Object)((Object)this));
        this.getApplication().setEnabledScreen(this);
        super.setEnabled(true);
    }

    public void cleanup() {
        if (this.isEnabled()) {
            this.disable();
        }
        super.cleanup();
    }

    @Override
    public void initialize(AppStateManager stateManager, Application application) {
        super.initialize(stateManager, application);
        this.getNifty().registerScreenController(new ScreenController[]{this});
        this.validateAndLoad();
        if (this.enableDuringInitialization) {
            this.enable();
        }
        assert (this.isInitialized());
    }

    public final void setEnabled(boolean newSetting) {
        if (!this.isInitialized()) {
            this.enableDuringInitialization = newSetting;
            return;
        }
        if (this.listener == null) {
            throw new IllegalStateException("listener should be set");
        }
        if (newSetting && !this.isEnabled()) {
            this.enable();
        } else if (!newSetting && this.isEnabled()) {
            this.disable();
        }
    }

    public void bind(Nifty nifty, Screen screen) {
        Validate.require((nifty == this.getNifty() ? 1 : 0) != 0, (String)"same Nifty instance");
        Validate.require((screen == this.getScreen() ? 1 : 0) != 0, (String)"same screen");
    }

    public void onEndScreen() {
    }

    public void onStartScreen() {
        this.hasStarted = true;
    }

    private void validateAndLoad() {
        assert (this.xmlAssetPath != null);
        logger.log(Level.INFO, "xmlAssetPath={0}", this.xmlAssetPath);
        Logger niftyLogger = Logger.getLogger(Nifty.class.getName());
        Level save = niftyLogger.getLevel();
        niftyLogger.setLevel(Level.SEVERE);
        try {
            this.getNifty().addXml(this.xmlAssetPath);
        }
        catch (Throwable exception) {
            String message = "while loading ScreenController layout from asset " + MyString.quote((CharSequence)this.xmlAssetPath);
            throw new RuntimeException(message, exception);
        }
        niftyLogger.setLevel(save);
    }
}

