/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.app.state.AppState;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.texture.image.ColorSpace;
import de.lessvoid.nifty.Nifty;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.nifty.BasicScreenController;
import jme3utilities.nifty.DialogInputMode;
import jme3utilities.nifty.MenuInputMode;
import jme3utilities.ui.ActionApplication;

public abstract class GuiApplication
extends ActionApplication {
    private static final Logger logger = Logger.getLogger(GuiApplication.class.getName());
    private BasicScreenController enabledScreen = null;
    private boolean niftyPostViewFlag = false;
    private NiftyJmeDisplay niftyDisplay = null;

    protected GuiApplication() {
    }

    protected GuiApplication(AppState ... initialAppStates) {
        super(initialAppStates);
    }

    public BasicScreenController getEnabledScreen() {
        return this.enabledScreen;
    }

    public Nifty getNifty() {
        Nifty result = this.getNiftyDisplay().getNifty();
        assert (result != null);
        return result;
    }

    public NiftyJmeDisplay getNiftyDisplay() {
        assert (this.niftyDisplay != null);
        return this.niftyDisplay;
    }

    public abstract void guiInitializeApplication();

    public void setEnabledScreen(BasicScreenController newScreen) {
        logger.log(Level.INFO, "newScreen={0}", (Object)newScreen);
        assert (newScreen == null || this.enabledScreen == null);
        this.enabledScreen = newScreen;
    }

    public void setNiftyPostView() {
        if (this.niftyDisplay != null) {
            throw new IllegalStateException("too late - already initialized");
        }
        this.niftyPostViewFlag = true;
    }

    public void acorusInit() {
        if (this.niftyDisplay != null) {
            throw new IllegalStateException("app should only be initialized once");
        }
        DialogInputMode dialogMode = new DialogInputMode();
        boolean success = this.stateManager.attach((AppState)dialogMode);
        assert (success);
        MenuInputMode menuMode = new MenuInputMode();
        success = this.stateManager.attach((AppState)menuMode);
        assert (success);
        ColorSpace colorSpace = this.renderer.isMainFrameBufferSrgb() ? ColorSpace.sRGB : ColorSpace.Linear;
        this.niftyDisplay = new NiftyJmeDisplay(this.assetManager, this.inputManager, this.audioRenderer, this.guiViewPort, colorSpace);
        if (this.niftyPostViewFlag) {
            int height = this.cam.getHeight();
            int width = this.cam.getWidth();
            Camera niftyCam = new Camera(width, height);
            ViewPort niftyView = this.renderManager.createPostView("NiftyGUI", niftyCam);
            niftyView.addProcessor((SceneProcessor)this.niftyDisplay);
        }
        Nifty nifty = this.getNifty();
        String niftyVersion = nifty.getVersion();
        logger.log(Level.INFO, "Nifty version is {0}", MyString.quote((CharSequence)niftyVersion));
        nifty.loadControlFile("nifty-default-controls.xml");
        nifty.loadStyleFile("/Interface/Nifty/nifty-default-styles.xml");
        String assetPath = "Interface/Nifty/popup-menu.xml";
        nifty.fromXmlWithoutStartScreen(assetPath);
        for (String dialogName : new String[]{"confirm", "info10", "multiSelect", "text-and-check", "text-and-slider", "text-entry"}) {
            assetPath = String.format("/Interface/Nifty/dialogs/%s.xml", dialogName);
            nifty.fromXmlWithoutStartScreen(assetPath);
        }
        this.guiInitializeApplication();
    }
}

