/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.cursors.plugins.JmeCursor;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.nifty.BasicScreenController;
import jme3utilities.nifty.GuiApplication;
import jme3utilities.nifty.PopScreenController;
import jme3utilities.ui.InputMode;

class MenuInputMode
extends InputMode {
    private static final Logger logger = Logger.getLogger(MenuInputMode.class.getName());
    private static final String cursorAssetPath = "Textures/cursors/menu.cur";
    public static final String name = "menu";

    MenuInputMode() {
        super(name);
    }

    public void onAction(String actionString, boolean ongoing, float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        if (!ongoing) {
            return;
        }
        logger.log(Level.INFO, "Got action {0}", MyString.quote((CharSequence)actionString));
        GuiApplication guiApplication = (GuiApplication)this.simpleApplication;
        BasicScreenController controller = guiApplication.getEnabledScreen();
        if (controller == null) {
            return;
        }
        PopScreenController psc = (PopScreenController)controller;
        assert (psc.hasActivePopupMenu());
        if (actionString.equals("close")) {
            psc.closeActivePopupMenu();
        } else if (actionString.startsWith("select ")) {
            String arg = MyString.remainder((String)actionString, (String)"select ");
            int position = Integer.parseInt(arg);
            int index = position - 1;
            psc.selectMenuItem(index);
        } else {
            guiApplication.onAction(actionString, ongoing, tpf);
        }
    }

    protected void defaultBindings() {
        this.bind("close", new int[]{1});
        this.bind("select 1", new int[]{2});
        this.bind("select 2", new int[]{3});
        this.bind("select 3", new int[]{4});
        this.bind("select 4", new int[]{5});
        this.bind("select 5", new int[]{6});
        this.bind("select 6", new int[]{7});
        this.bind("select 7", new int[]{8});
        this.bind("select 8", new int[]{9});
        this.bind("select 9", new int[]{10});
        this.bind("select 10", new int[]{11});
        this.bind("SIMPLEAPP_HideStats", new int[]{63});
    }

    public void initialize(AppStateManager stateManager, Application application) {
        AssetManager am = application.getAssetManager();
        JmeCursor cursor = (JmeCursor)am.loadAsset(cursorAssetPath);
        this.setCursor(cursor);
        super.initialize(stateManager, application);
    }
}

