/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import de.lessvoid.nifty.controls.ListBox;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.Validate;
import jme3utilities.nifty.GuiScreenController;

public class MessageDisplay
extends GuiScreenController {
    private static final Logger logger = Logger.getLogger(MessageDisplay.class.getName());
    private final Deque<String> backlog = new ArrayDeque<String>(4);

    public MessageDisplay() {
        super("message-display", "Interface/Nifty/huds/message-display.xml", InitialState.Disabled);
    }

    public void addLine(String line) {
        Validate.nonNull((Object)line, (String)"line");
        if (!this.isInitialized()) {
            this.backlog.add(line);
            return;
        }
        this.setEnabled(true);
        ListBox listBox = (ListBox)this.getScreen().findNiftyControl("messages", ListBox.class);
        listBox.enable();
        int rows = listBox.getDisplayItemCount();
        while (listBox.itemCount() >= rows) {
            listBox.removeItemByIndex(0);
        }
        listBox.addItem((Object)line);
    }

    @Override
    public void initialize(AppStateManager stateManager, Application application) {
        super.initialize(stateManager, application);
        assert (this.isInitialized());
        for (String line : this.backlog) {
            this.addLine(line);
        }
        this.backlog.clear();
    }
}

