/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.MenuItemActivatedEvent;
import de.lessvoid.nifty.elements.Element;
import java.util.logging.Logger;
import jme3utilities.nifty.PopScreenController;
import org.bushe.swing.event.EventTopicSubscriber;

public class PopupMenu
implements EventTopicSubscriber<MenuItemActivatedEvent<String>> {
    private static final Logger logger = Logger.getLogger(PopupMenu.class.getName());
    private final PopScreenController screenController;
    private final PopupMenu parent;
    private final String actionPrefix;
    private final String[] itemArray;
    private final String popupId;

    PopupMenu(String popupId, String actionPrefix, String[] itemArray, PopScreenController screenController) {
        assert (popupId != null);
        assert (actionPrefix != null);
        assert (itemArray != null);
        assert (screenController != null);
        this.popupId = popupId;
        this.actionPrefix = actionPrefix;
        this.itemArray = (String[])itemArray.clone();
        this.parent = null;
        this.screenController = screenController;
    }

    PopupMenu(String popupId, String actionPrefix, String[] itemArray, PopupMenu parent) {
        assert (popupId != null);
        assert (actionPrefix != null);
        assert (itemArray != null);
        assert (parent != null);
        this.popupId = popupId;
        this.actionPrefix = actionPrefix;
        this.itemArray = (String[])itemArray.clone();
        this.parent = parent;
        this.screenController = parent.getScreenController();
    }

    String actionString(int index) {
        if (index < 0 || index >= this.itemArray.length) {
            return null;
        }
        String itemName = this.itemArray[index];
        String actionString = this.actionPrefix + itemName;
        return actionString;
    }

    void close() {
        Nifty nifty = this.screenController.getNifty();
        nifty.closePopup(this.popupId);
    }

    String getElementId() {
        assert (this.popupId != null);
        return this.popupId;
    }

    PopupMenu getParent() {
        return this.parent;
    }

    PopScreenController getScreenController() {
        return this.screenController;
    }

    void setEnabled(boolean newState) {
        Element element = this.getElement();
        if (newState) {
            element.enable();
        } else {
            element.disable();
        }
    }

    public void onEvent(String controlId, MenuItemActivatedEvent<String> event) {
        String itemName = (String)event.getItem();
        String actionString = this.actionPrefix + itemName;
        this.screenController.perform(actionString);
        this.screenController.closePopupMenu(this);
    }

    private Element getElement() {
        Nifty nifty = this.screenController.getNifty();
        Element element = nifty.findPopupByName(this.popupId);
        assert (element != null);
        return element;
    }
}

