/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PopupMenuBuilder {
    private static final Logger logger = Logger.getLogger(PopupMenuBuilder.class.getName());
    protected final List<String> iconAssetPaths = new ArrayList<String>(40);
    protected final List<String> items = new ArrayList<String>(40);

    public void add(String item) {
        Validate.nonEmpty((String)item, (String)"item");
        assert (!this.items.contains(item)) : item;
        this.items.add(item);
        this.iconAssetPaths.add(null);
    }

    public void add(String item, String iconAssetPath) {
        Validate.nonEmpty((String)item, (String)"item");
        assert (!this.items.contains(item)) : item;
        this.items.add(item);
        this.iconAssetPaths.add(iconAssetPath);
    }

    public void addAll(Iterable<String> items) {
        Validate.nonNull(items, (String)"items");
        for (String item : items) {
            this.add(item);
        }
    }

    public String[] copyIconAssetPaths() {
        int numIcons = this.iconAssetPaths.size();
        String[] result = new String[numIcons];
        for (int i = 0; i < numIcons; ++i) {
            result[i] = this.iconAssetPaths.get(i);
        }
        return result;
    }

    public String[] copyItems() {
        int numItems = this.items.size();
        String[] result = new String[numItems];
        for (int i = 0; i < numItems; ++i) {
            result[i] = this.items.get(i);
        }
        return result;
    }

    public boolean hasItem(String item) {
        Validate.nonEmpty((String)item, (String)"item");
        boolean result = this.items.contains(item);
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.items.isEmpty();
        return result;
    }

    public void reset() {
        this.items.clear();
        this.iconAssetPaths.clear();
    }
}

