/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.MyString;
import jme3utilities.nifty.GuiScreenController;
import jme3utilities.nifty.GuiWindowController;

public abstract class Tool
extends GuiWindowController {
    private static final Logger logger = Logger.getLogger(Tool.class.getName());
    private final String toolName;

    protected Tool(GuiScreenController screenController, String name) {
        super(screenController, name + "Tool", InitialState.Disabled);
        this.toolName = name;
    }

    public void onCheckBoxChanged(String name, boolean isChecked) {
        logger.log(Level.WARNING, "unexpected check-box change ignored, name={0}", MyString.quote((CharSequence)name));
    }

    public void onRadioButtonChanged(String buttonName) {
        logger.warning("unexpected radio-button change ignored");
    }

    public void onSliderChanged(String sliderName) {
        logger.warning("unexpected slider change ignored");
    }

    protected List<String> listCheckBoxes() {
        ArrayList<String> result = new ArrayList<String>(5);
        return result;
    }

    protected List<String> listRadioButtons() {
        ArrayList<String> result = new ArrayList<String>(5);
        return result;
    }

    protected List<String> listSliders() {
        ArrayList<String> result = new ArrayList<String>(5);
        return result;
    }

    protected void setSlidersEnabled(boolean newState) {
        List<String> list = this.listSliders();
        for (String sliderName : list) {
            this.setSliderEnabled(sliderName, newState);
        }
    }

    protected abstract void toolUpdate();

    @Override
    public void initialize(AppStateManager stateManager, Application application) {
        super.initialize(stateManager, application);
        GuiScreenController screen = this.getScreenController();
        screen.mapTool(this.toolName, this);
        List<String> checkBoxNames = this.listCheckBoxes();
        for (String string : checkBoxNames) {
            screen.mapCheckBox(string, this);
        }
        List<String> radioButtonNames = this.listRadioButtons();
        for (String name : radioButtonNames) {
            screen.mapRadioButton(name, this);
        }
        List<String> list = this.listSliders();
        for (String name : list) {
            screen.mapSlider(name, this);
        }
    }

    @Override
    public final void update(float tpf) {
        super.update(tpf);
        GuiScreenController screenController = this.getScreenController();
        screenController.setIgnoreGuiChanges(true);
        this.toolUpdate();
        screenController.setIgnoreGuiChanges(false);
    }
}

