/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.bind;

import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.ui.Hotkey;
import jme3utilities.ui.InputMode;

class HotkeyItem {
    private static final Logger logger = Logger.getLogger(HotkeyItem.class.getName());
    private final Hotkey hotkey;
    private final InputMode mode;

    HotkeyItem(Hotkey hotkey, InputMode mode) {
        assert (hotkey != null);
        assert (mode != null);
        this.hotkey = hotkey;
        this.mode = mode;
    }

    Hotkey getHotkey() {
        return this.hotkey;
    }

    boolean isBound() {
        boolean result = this.mode.binds(this.hotkey);
        return result;
    }

    boolean isForCode(int code) {
        int thisCode = this.hotkey.code();
        return thisCode == code;
    }

    public String toString() {
        if (this.mode == null) {
            return "";
        }
        String name = this.hotkey.localName();
        String result = String.format(" [ %s ]    ... ", name);
        if (this.isBound()) {
            String action = this.mode.findActionName(this.hotkey);
            result = result + String.format("bound to %s", MyString.quote((CharSequence)action));
        } else {
            result = result + "not bound";
        }
        return result;
    }
}

