/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import java.util.Locale;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.RectSizeLimits;
import jme3utilities.nifty.dialog.TextEntryDialog;
import jme3utilities.ui.DsUtils;

public class DisplaySizeDialog
extends TextEntryDialog {
    private static final Logger logger = Logger.getLogger(DisplaySizeDialog.class.getName());
    public final RectSizeLimits sizeLimits;

    public DisplaySizeDialog(String description, RectSizeLimits limits) {
        super(description);
        Validate.nonNull((Object)limits, (String)"limits");
        this.sizeLimits = limits;
    }

    @Override
    protected String feedback(String input) {
        String msg;
        Validate.nonNull((Object)input, (String)"input");
        String lcInput = input.toLowerCase(Locale.ROOT);
        if ("min".equals(lcInput) || "max".equals(lcInput)) {
            msg = "";
        } else {
            int[] size = DsUtils.parseDimensions((String)lcInput);
            if (size == null) {
                msg = "improperly formatted display dimensions";
            } else {
                int width = size[0];
                int height = size[1];
                msg = this.sizeLimits.feedbackInRange(width, height);
            }
        }
        return msg;
    }
}

