/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import com.jme3.math.FastMath;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.Slider;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.nifty.dialog.DialogController;

public class FloatSliderDialog
implements DialogController {
    private static final Logger logger = Logger.getLogger(FloatSliderDialog.class.getName());
    private boolean ignoreChanges = false;
    private final float maxValue;
    private final float minValue;
    private final String commitDescription;

    public FloatSliderDialog(String description, float min, float max) {
        Validate.nonEmpty((String)description, (String)"description");
        Validate.require((min < max ? 1 : 0) != 0, (String)"min < max");
        this.commitDescription = description;
        this.minValue = min;
        this.maxValue = max;
    }

    public void onSliderChanged(Element dialogElement) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        if (this.ignoreChanges) {
            return;
        }
        Slider slider = (Slider)dialogElement.findNiftyControl("#dialogslider", Slider.class);
        float raw = slider.getValue();
        float newValue = MyMath.lerp((float)raw, (float)this.minValue, (float)this.maxValue);
        TextField textField = (TextField)dialogElement.findNiftyControl("#textfield", TextField.class);
        String newText = Float.toString(newValue);
        textField.setText((CharSequence)newText);
    }

    protected String feedback(String inputText) {
        String msg = "";
        try {
            float inputValue = Float.parseFloat(inputText);
            if (inputValue < this.minValue) {
                String minText = Float.toString(this.minValue);
                msg = String.format("must not be < %s", minText);
            } else if (inputValue > this.maxValue) {
                String maxText = Float.toString(this.maxValue);
                msg = String.format("must not be > %s", maxText);
            } else if (Float.isNaN(inputValue)) {
                msg = "must be a number";
            }
        }
        catch (NumberFormatException exception) {
            msg = "must be a number";
        }
        return msg;
    }

    protected String text(Element dialogElement) {
        TextField textField = (TextField)dialogElement.findNiftyControl("#textfield", TextField.class);
        String text = textField.getRealText();
        assert (text != null);
        return text;
    }

    @Override
    public boolean allowCommit(Element dialogElement) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        String text = this.text(dialogElement);
        String feedback = this.feedback(text);
        boolean allow = feedback.isEmpty();
        return allow;
    }

    @Override
    public String commitSuffix(Element dialogElement) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        String suffix = this.text(dialogElement);
        return suffix;
    }

    @Override
    public void update(Element dialogElement, float unused) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        this.ignoreChanges = true;
        String text = this.text(dialogElement);
        String feedback = this.feedback(text);
        Button commitButton = (Button)dialogElement.findNiftyControl("#commit", Button.class);
        Element feedbackElement = dialogElement.findElementById("#feedback");
        TextRenderer renderer = (TextRenderer)feedbackElement.getRenderer(TextRenderer.class);
        renderer.setText(feedback);
        if (feedback.isEmpty()) {
            commitButton.setText(this.commitDescription);
            commitButton.getElement().show();
            Slider slider = (Slider)dialogElement.findNiftyControl("#dialogslider", Slider.class);
            float value = Float.parseFloat(text);
            float raw = FastMath.unInterpolateLinear((float)value, (float)this.minValue, (float)this.maxValue);
            slider.setValue(raw);
        } else {
            commitButton.setText("");
            commitButton.getElement().hide();
        }
        this.ignoreChanges = false;
    }
}

