/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import java.util.Locale;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.nifty.dialog.AllowNull;
import jme3utilities.nifty.dialog.TextEntryDialog;

public class LongDialog
extends TextEntryDialog {
    private static final Logger logger = Logger.getLogger(LongDialog.class.getName());
    private final AllowNull allowNull;
    private final long maxValue;
    private final long minValue;

    public LongDialog(String description, long min, long max, AllowNull allowNull) {
        super(description);
        Validate.require((min < max ? 1 : 0) != 0, (String)"min < max");
        Validate.nonNull((Object)((Object)allowNull), (String)"allow null");
        this.minValue = min;
        this.maxValue = max;
        this.allowNull = allowNull;
    }

    @Override
    protected String feedback(String input) {
        Validate.nonNull((Object)input, (String)"input");
        String msg = "";
        try {
            long inputValue = Long.parseLong(input);
            if (inputValue < this.minValue) {
                msg = String.format("must not be < %d", this.minValue);
            } else if (inputValue > this.maxValue) {
                msg = String.format("must not be > %d", this.maxValue);
            }
        }
        catch (NumberFormatException exception) {
            msg = this.notANumber();
        }
        String lcText = input.toLowerCase(Locale.ROOT);
        if (this.allowNull.equals((Object)AllowNull.Yes) && LongDialog.matchesNull(lcText)) {
            msg = "";
        }
        return msg;
    }

    private String notANumber() {
        if (this.allowNull.equals((Object)AllowNull.Yes)) {
            return "must be a number or null";
        }
        return "must be a number";
    }
}

