/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.nifty.dialog.DialogController;

public class MultiSelectDialog<ItemType>
implements DialogController {
    private static final Logger logger = Logger.getLogger(MultiSelectDialog.class.getName());
    private final List<ItemType> allItems;
    private final String commitDescription;

    public MultiSelectDialog(String description, List<ItemType> itemList) {
        Validate.nonEmpty((String)description, (String)"description");
        Validate.nonEmpty(itemList, (String)"item list");
        this.commitDescription = description;
        this.allItems = new ArrayList<ItemType>(itemList);
    }

    public final String commitDescription() {
        assert (this.commitDescription != null);
        assert (!this.commitDescription.isEmpty());
        return this.commitDescription;
    }

    public final int countItems() {
        int result = this.allItems.size();
        return result;
    }

    public final ItemType getItem(int index) {
        ItemType result = this.allItems.get(index);
        return result;
    }

    public final List<String> listItemDescriptions() {
        int numItems = this.countItems();
        ArrayList<String> result = new ArrayList<String>(numItems);
        for (ItemType item : this.allItems) {
            String description = item.toString();
            result.add(description);
        }
        return result;
    }

    public final List<ItemType> listItems() {
        List<ItemType> result = Collections.unmodifiableList(this.allItems);
        return result;
    }

    public BitSet parseBitSet(String commitSuffix) {
        Validate.nonEmpty((String)commitSuffix, (String)"commit suffix");
        int size = this.countItems();
        BitSet result = new BitSet(size);
        String[] selectedDigits = commitSuffix.split(",");
        int numSelected = selectedDigits.length;
        for (String digits : selectedDigits) {
            int index = Integer.parseInt(digits);
            result.set(index);
        }
        return result;
    }

    public String[] parseDescriptionArray(String commitSuffix) {
        Validate.nonEmpty((String)commitSuffix, (String)"commit suffix");
        String[] selectedDigits = commitSuffix.split(",");
        int numSelected = selectedDigits.length;
        String[] result = new String[numSelected];
        for (int i = 0; i < numSelected; ++i) {
            String description;
            String digits = selectedDigits[i];
            int index = Integer.parseInt(digits);
            ItemType item = this.allItems.get(index);
            result[i] = description = item.toString();
        }
        return result;
    }

    public List<ItemType> parseItemList(String commitSuffix) {
        Validate.nonEmpty((String)commitSuffix, (String)"commit suffix");
        String[] selectedDigits = commitSuffix.split(",");
        int numSelected = selectedDigits.length;
        ArrayList<ItemType> result = new ArrayList<ItemType>(numSelected);
        for (String digits : selectedDigits) {
            int index = Integer.parseInt(digits);
            ItemType item = this.getItem(index);
            result.add(item);
        }
        return result;
    }

    protected String feedback(List<Integer> indexList) {
        String result = "";
        return result;
    }

    @Override
    public boolean allowCommit(Element dialogElement) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        List<Integer> indices = MultiSelectDialog.getSelectedIndices(dialogElement);
        String feedback = this.feedback(indices);
        boolean allow = feedback.isEmpty();
        return allow;
    }

    @Override
    public String commitSuffix(Element dialogElement) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        List<Integer> indices = MultiSelectDialog.getSelectedIndices(dialogElement);
        String result = MyString.join((CharSequence)",", indices);
        return result;
    }

    @Override
    public void update(Element dialogElement, float ignored) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        List<Integer> indices = MultiSelectDialog.getSelectedIndices(dialogElement);
        String feedbackMessage = this.feedback(indices);
        String commitLabel = feedbackMessage.isEmpty() ? this.commitDescription : "";
        Button commitButton = (Button)dialogElement.findNiftyControl("#commit", Button.class);
        commitButton.setText(commitLabel);
        boolean makeButtonVisible = !commitLabel.isEmpty();
        commitButton.getElement().setVisible(makeButtonVisible);
        Element feedbackElement = dialogElement.findElementById("#feedback");
        TextRenderer renderer = (TextRenderer)feedbackElement.getRenderer(TextRenderer.class);
        renderer.setText(feedbackMessage);
        int numSelected = indices.size();
        int numItems = this.countItems();
        String numSelectedMessage = String.format("Selected %d of %d.", numSelected, numItems);
        Element numSelectedElement = dialogElement.findElementById("#numSelected");
        renderer = (TextRenderer)numSelectedElement.getRenderer(TextRenderer.class);
        renderer.setText(numSelectedMessage);
    }

    private static List<Integer> getSelectedIndices(Element dialogElement) {
        assert (dialogElement != null);
        ListBox listBox = (ListBox)dialogElement.findNiftyControl("#box", ListBox.class);
        List result = listBox.getSelectedIndices();
        return result;
    }
}

