/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3utilities.Validate;
import jme3utilities.nifty.dialog.DialogController;

public class TextEntryDialog
implements DialogController {
    private static final Logger logger = Logger.getLogger(TextEntryDialog.class.getName());
    private static final Pattern nullPattern = Pattern.compile("\\s*null\\s*");
    private final String commitDescription;

    public TextEntryDialog(String description) {
        Validate.nonEmpty((String)description, (String)"description");
        this.commitDescription = description;
    }

    protected String feedback(String inputText) {
        return "";
    }

    protected static boolean matchesNull(CharSequence lcText) {
        Validate.nonNull((Object)lcText, (String)"lc text");
        Matcher matcher = nullPattern.matcher(lcText);
        boolean result = matcher.matches();
        return result;
    }

    protected String text(Element dialogElement) {
        TextField textField = (TextField)dialogElement.findNiftyControl("#textfield", TextField.class);
        String text = textField.getRealText();
        assert (text != null);
        return text;
    }

    @Override
    public boolean allowCommit(Element dialogElement) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        String text = this.text(dialogElement);
        String feedback = this.feedback(text);
        boolean allow = feedback.isEmpty();
        return allow;
    }

    @Override
    public String commitSuffix(Element dialogElement) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        String suffix = this.text(dialogElement);
        return suffix;
    }

    @Override
    public void update(Element dialogElement, float ignored) {
        Validate.nonNull((Object)dialogElement, (String)"dialog element");
        String text = this.text(dialogElement);
        String feedbackMessage = this.feedback(text);
        String commitLabel = feedbackMessage.isEmpty() ? this.commitDescription : "";
        Button commitButton = (Button)dialogElement.findNiftyControl("#commit", Button.class);
        commitButton.setText(commitLabel);
        boolean makeButtonVisible = !commitLabel.isEmpty();
        commitButton.getElement().setVisible(makeButtonVisible);
        Element feedbackElement = dialogElement.findElementById("#feedback");
        TextRenderer renderer = (TextRenderer)feedbackElement.getRenderer(TextRenderer.class);
        renderer.setText(feedbackMessage);
    }
}

