/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.Validate;
import jme3utilities.nifty.BasicScreenController;
import jme3utilities.nifty.GuiScreenController;
import jme3utilities.nifty.SliderTransform;
import jme3utilities.nifty.WindowController;

public class GuiWindowController
extends WindowController {
    private static final Logger logger = Logger.getLogger(GuiWindowController.class.getName());

    public GuiWindowController(GuiScreenController screenController, String controlId, boolean startEnabled) {
        super((BasicScreenController)screenController, controlId, startEnabled);
        assert (!this.isInitialized());
        assert (this.isEnabled());
    }

    public GuiWindowController(GuiScreenController screenController, String controlId, InitialState initialState) {
        super((BasicScreenController)screenController, controlId, initialState);
        assert (!this.isInitialized());
        assert (this.isEnabled());
    }

    public void disableCheckBox(String name) {
        Validate.nonNull((Object)name, (String)"check-box name");
        this.getScreenController().disableCheckBox(name);
    }

    public ColorRGBA readColorBank(String bankName, SliderTransform transform, ColorRGBA storeResult) {
        Validate.nonNull((Object)bankName, (String)"bank name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        GuiScreenController gsc = this.getScreenController();
        ColorRGBA color = gsc.readColorBank(bankName, transform, storeResult);
        return color;
    }

    public float readSlider(String name, SliderTransform transform) {
        Validate.nonNull((Object)name, (String)"slider name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        float result = this.getScreenController().readSlider(name, transform);
        return result;
    }

    public Vector3f readVectorBank(String bankName, SliderTransform transform, Vector3f storeResult) {
        Validate.nonNull((Object)bankName, (String)"bank name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        GuiScreenController gsc = this.getScreenController();
        gsc.readVectorBank(bankName, transform, result);
        return result;
    }

    public void setButtonText(String name, String newText) {
        Validate.nonNull((Object)name, (String)"button name");
        Validate.nonNull((Object)newText, (String)"new text");
        this.getScreenController().setButtonText(name, newText);
    }

    public void setChecked(String name, boolean newStatus) {
        Validate.nonNull((Object)name, (String)"check-box name");
        this.getScreenController().setChecked(name, newStatus);
    }

    public void setColorBank(String name, SliderTransform transform, ColorRGBA color) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        Validate.nonNull((Object)color, (String)"color");
        this.getScreenController().setColorBank(name, transform, color);
    }

    public void setSlider(String name, SliderTransform transform, float inputValue) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        this.getScreenController().setSlider(name, transform, inputValue);
    }

    public void setSliderEnabled(String name, boolean newState) {
        Validate.nonNull((Object)name, (String)"name");
        this.getScreenController().setSliderEnabled(name, newState);
    }

    public void setStatusText(String elementId, String newText) {
        Validate.nonNull((Object)elementId, (String)"element id");
        Validate.nonNull((Object)newText, (String)"text");
        this.getScreenController().setStatusText(elementId, newText);
    }

    public void updateSliderStatus(String name, float value, String statusSuffix) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)statusSuffix, (String)"status suffix");
        this.getScreenController().updateSliderStatus(name, value, statusSuffix);
    }

    @Override
    public GuiScreenController getScreenController() {
        BasicScreenController bsc = super.getScreenController();
        GuiScreenController result = (GuiScreenController)bsc;
        assert (result != null);
        return result;
    }
}

