/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.bind;

import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.ui.InputMode;

class ActionItem {
    private static final Logger logger = Logger.getLogger(ActionItem.class.getName());
    private final InputMode mode;
    private final String actionName;

    ActionItem(String actionName, InputMode mode) {
        assert (actionName != null);
        assert (mode != null);
        this.actionName = actionName;
        this.mode = mode;
    }

    String getActionName() {
        return this.actionName;
    }

    public String toString() {
        String result = String.format("  %s", MyString.quote((CharSequence)this.actionName));
        Collection names = this.mode.listHotkeysLocal(this.actionName);
        if (!names.isEmpty()) {
            result = result + String.format(":     %s", ActionItem.formatList(names));
        }
        return result;
    }

    private static String formatList(Collection<String> names) {
        StringBuilder result = new StringBuilder(30);
        boolean firstFlag = true;
        for (String keyName : names) {
            if (!firstFlag) {
                result.append(" and ");
            }
            result.append(String.format("[ %s ]", keyName));
            firstFlag = false;
        }
        return result.toString();
    }
}

