/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.bind;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.cursors.plugins.JmeCursor;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.nifty.bind.BindScreen;
import jme3utilities.ui.Hotkey;
import jme3utilities.ui.InputMode;

public class BindInputMode
extends InputMode {
    private static final Logger logger = Logger.getLogger(BindInputMode.class.getName());
    private static final String assetPath = "Textures/cursors/default.cur";
    private final BindScreen screen;

    BindInputMode(BindScreen screen) {
        super("bind");
        Validate.nonNull((Object)((Object)screen), (String)"screen");
        this.screen = screen;
    }

    public void onAction(String actionString, boolean ongoing, float ignored) {
        this.screen.onAction(actionString, ongoing, ignored);
    }

    protected void defaultBindings() {
        for (Hotkey hotkey : Hotkey.listAll()) {
            if (BindScreen.isExempt(hotkey)) continue;
            int code = hotkey.code();
            String actionString = String.format("select %d", code);
            this.bind(actionString, hotkey);
        }
    }

    public void initialize(AppStateManager stateManager, Application application) {
        Validate.nonNull((Object)stateManager, (String)"state manager");
        Validate.nonNull((Object)application, (String)"application");
        AssetManager am = application.getAssetManager();
        JmeCursor cursor = (JmeCursor)am.loadAsset(assetPath);
        this.setCursor(cursor);
        super.initialize(stateManager, application);
    }
}

