/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.bind;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.controls.ActionListener;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.screen.Screen;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.nifty.GuiScreenController;
import jme3utilities.nifty.bind.ActionItem;
import jme3utilities.nifty.bind.BindInputMode;
import jme3utilities.nifty.bind.HotkeyItem;
import jme3utilities.ui.Hotkey;
import jme3utilities.ui.InputMode;

public class BindScreen
extends GuiScreenController
implements ActionListener {
    private static final Logger logger = Logger.getLogger(BindScreen.class.getName());
    public static final String name = "bind";
    private InputMode subjectMode = null;
    private final BindInputMode inputMode = new BindInputMode(this);

    public BindScreen() {
        super(name, "Interface/Nifty/screens/bind.xml", InitialState.Disabled);
        this.setListener((ActionListener)this.inputMode);
        this.influence((AppState)this.inputMode);
        this.inputMode.influence((AppState)this);
        assert (!this.isEnabled());
        assert (!this.isInitialized());
    }

    public void activate(InputMode mode) {
        Validate.nonNull((Object)mode, (String)"input mode");
        Validate.require((boolean)mode.isEnabled(), (String)"an enabled input mode");
        assert (!this.isEnabled());
        assert (this.isInitialized());
        assert (this.subjectMode == null) : this.subjectMode;
        this.closeAllPopups();
        this.subjectMode = mode;
        this.subjectMode.setEnabled(false);
        this.setEnabled(true);
    }

    void deactivate() {
        assert (this.isEnabled());
        assert (this.subjectMode != null);
        assert (!this.subjectMode.isEnabled());
        this.setEnabled(false);
        this.subjectMode.setEnabled(true);
        this.subjectMode = null;
    }

    static boolean isExempt(Hotkey hotkey) {
        assert (hotkey != null);
        int keyCode = hotkey.keyCode();
        switch (keyCode) {
            case 15: 
            case 28: 
            case 57: 
            case 69: 
            case 183: 
            case 200: 
            case 208: 
            case 219: {
                return true;
            }
        }
        return false;
    }

    public void onAction(String actionString, boolean ongoing, float ignored) {
        String verb;
        if (!ongoing) {
            return;
        }
        logger.log(Level.INFO, "Got action {0}", MyString.quote((CharSequence)actionString));
        if (actionString.equals("close")) {
            this.deactivate();
            return;
        }
        String[] words = actionString.split("\\s+");
        assert (words.length > 0) : words;
        switch (verb = words[0]) {
            case "bind": {
                if (words.length != 1) break;
                this.bindSelected();
                return;
            }
            case "load": {
                if (words.length != 1) break;
                this.subjectMode.loadBindings();
                return;
            }
            case "return": {
                if (words.length != 1) break;
                this.deactivate();
                return;
            }
            case "save": {
                if (words.length != 1) break;
                this.subjectMode.saveBindings();
                return;
            }
            case "select": {
                if (words.length != 2) break;
                int keyCode = Integer.parseInt(words[1]);
                this.selectHotkey(keyCode);
                return;
            }
            case "unbind": {
                if (words.length != 1) break;
                this.unbindSelectedHotkey();
                return;
            }
        }
        logger.log(Level.WARNING, "Action {0} was not handled.", MyString.quote((CharSequence)actionString));
    }

    @Override
    public void bind(Nifty nifty, Screen screen) {
        Validate.nonNull((Object)nifty, (String)"nifty");
        Validate.nonNull((Object)screen, (String)"screen");
        super.bind(nifty, screen);
        ListBox<ActionItem> actionBox = this.getActionBox();
        actionBox.clear();
        List actionNames = this.subjectMode.listActionNames();
        Collections.sort(actionNames);
        for (String actionName : actionNames) {
            ActionItem item = new ActionItem(actionName, this.subjectMode);
            actionBox.addItem((Object)item);
        }
        ListBox<HotkeyItem> hotkeyBox = this.getHotkeyBox();
        hotkeyBox.clear();
        this.populateHotkeyBox(true);
        this.populateHotkeyBox(false);
    }

    @Override
    public void initialize(AppStateManager stateManager, Application application) {
        assert (!this.isInitialized());
        assert (!this.isEnabled());
        this.inputMode.initialize(stateManager, application);
        super.initialize(stateManager, application);
    }

    @Override
    public void update(float tpf) {
        assert (this.isEnabled());
        super.update(tpf);
        Screen screen = this.getScreen();
        if (!screen.isBound()) {
            return;
        }
        this.getActionBox().refresh();
        this.getHotkeyBox().refresh();
        this.updateButtonLabels();
        String modeStatus = String.format("Edit hotkey bindings for %s input mode", MyString.quote((CharSequence)this.subjectMode.shortName()));
        this.setStatusText("modeStatus", modeStatus);
        String configPath = this.subjectMode.configPath();
        if (configPath == null) {
            this.setStatusText("configStatus", "");
        } else {
            String configStatus = String.format("Path for load/save is %s", MyString.quote((CharSequence)configPath));
            this.setStatusText("configStatus", configStatus);
        }
    }

    private void bindSelected() {
        Hotkey hotkey = this.getSelectedHotkey();
        assert (hotkey != null);
        String actionName = this.getSelectedAction();
        assert (actionName != null);
        this.subjectMode.bind(actionName, hotkey);
    }

    private ActionItem findActionItem(String actionName) {
        assert (actionName != null);
        ListBox<ActionItem> actionBox = this.getActionBox();
        List list = actionBox.getItems();
        for (ActionItem item : list) {
            String itemName = item.getActionName();
            if (!actionName.equals(itemName)) continue;
            return item;
        }
        return null;
    }

    private HotkeyItem findHotkeyItem(int code) {
        ListBox<HotkeyItem> listBox = this.getHotkeyBox();
        List list = listBox.getItems();
        for (HotkeyItem item : list) {
            if (!item.isForCode(code)) continue;
            return item;
        }
        return null;
    }

    private ListBox<ActionItem> getActionBox() {
        Screen screen = this.getScreen();
        ListBox listBox = (ListBox)screen.findNiftyControl("actionList", ListBox.class);
        assert (listBox != null);
        return listBox;
    }

    private ListBox<HotkeyItem> getHotkeyBox() {
        Screen screen = this.getScreen();
        ListBox listBox = (ListBox)screen.findNiftyControl("hotkeyList", ListBox.class);
        assert (listBox != null);
        return listBox;
    }

    private String getSelectedAction() {
        ListBox<ActionItem> listBox = this.getActionBox();
        List selection = listBox.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        ActionItem item = (ActionItem)selection.get(0);
        String actionName = item.getActionName();
        return actionName;
    }

    private Hotkey getSelectedHotkey() {
        ListBox<HotkeyItem> listBox = this.getHotkeyBox();
        List selection = listBox.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        HotkeyItem item = (HotkeyItem)selection.get(0);
        Hotkey hotkey = item.getHotkey();
        return hotkey;
    }

    private boolean isActionSelected() {
        ListBox<ActionItem> listBox = this.getActionBox();
        List selection = listBox.getSelection();
        boolean result = !selection.isEmpty();
        return result;
    }

    private boolean isBoundHotkeySelected() {
        ListBox<HotkeyItem> listBox = this.getHotkeyBox();
        List selection = listBox.getSelection();
        for (HotkeyItem item : selection) {
            if (!item.isBound()) continue;
            return true;
        }
        return false;
    }

    private boolean isHotkeySelected() {
        ListBox<HotkeyItem> listBox = this.getHotkeyBox();
        List selection = listBox.getSelection();
        boolean result = !selection.isEmpty();
        return result;
    }

    private void populateHotkeyBox(boolean boundFlag) {
        ListBox<HotkeyItem> listBox = this.getHotkeyBox();
        List allHotkeys = Hotkey.listAll();
        for (Hotkey hotkey : allHotkeys) {
            if (BindScreen.isExempt(hotkey) || this.subjectMode.binds(hotkey) != boundFlag) continue;
            HotkeyItem item = new HotkeyItem(hotkey, this.subjectMode);
            listBox.addItem((Object)item);
        }
    }

    private void selectHotkey(int code) {
        HotkeyItem item = this.findHotkeyItem(code);
        assert (item != null);
        ListBox<HotkeyItem> listBox = this.getHotkeyBox();
        listBox.setFocusItem((Object)item);
        listBox.selectItem((Object)item);
        Hotkey hotkey = item.getHotkey();
        if (this.subjectMode.binds(hotkey)) {
            String actionName = this.subjectMode.findActionName(hotkey);
            ActionItem actionItem = this.findActionItem(actionName);
            ListBox<ActionItem> actionBox = this.getActionBox();
            actionBox.selectItem((Object)actionItem);
        }
    }

    private void unbindSelectedHotkey() {
        Hotkey hotkey = this.getSelectedHotkey();
        assert (hotkey != null);
        this.subjectMode.unbind(hotkey);
    }

    private void updateButtonLabels() {
        String bindLabel = "";
        if (this.isHotkeySelected() && this.isActionSelected() && !this.isBoundHotkeySelected()) {
            bindLabel = "Bind";
        }
        this.setButtonText(name, bindLabel);
        String returnLabel = String.format("Return to %s mode", MyString.quote((CharSequence)this.subjectMode.shortName()));
        this.setButtonText("return", returnLabel);
        String unbindLabel = "";
        if (this.isBoundHotkeySelected()) {
            unbindLabel = "Unbind selected hotkey";
        }
        this.setButtonText("unbind", unbindLabel);
        String loadLabel = "";
        String saveLabel = "";
        if (this.subjectMode.configPath() != null) {
            loadLabel = "Load from file";
            saveLabel = "Save to file";
        }
        this.setButtonText("loadConfig", loadLabel);
        this.setButtonText("saveConfig", saveLabel);
    }
}

