/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3utilities.Validate;
import jme3utilities.nifty.dialog.AllowNull;
import jme3utilities.nifty.dialog.TextEntryDialog;

public class BooleanDialog
extends TextEntryDialog {
    private static final Logger logger = Logger.getLogger(BooleanDialog.class.getName());
    private static final Pattern falsePattern = Pattern.compile("\\s*false\\s*");
    private static final Pattern truePattern = Pattern.compile("\\s*true\\s*");
    private final AllowNull allowNull;

    public BooleanDialog(String description, AllowNull allowNull) {
        super(description);
        Validate.nonNull((Object)((Object)allowNull), (String)"allow null");
        this.allowNull = allowNull;
    }

    @Override
    protected String feedback(String input) {
        Validate.nonNull((Object)input, (String)"input");
        String lcText = input.toLowerCase(Locale.ROOT);
        String msg = this.notABoolean();
        if (BooleanDialog.matchesTrue(lcText) || BooleanDialog.matchesFalse(lcText)) {
            msg = "";
        } else if (this.allowNull.equals((Object)AllowNull.Yes) && BooleanDialog.matchesNull(lcText)) {
            msg = "";
        }
        return msg;
    }

    private static boolean matchesFalse(String lcText) {
        assert (lcText != null);
        Matcher matcher = falsePattern.matcher(lcText);
        boolean result = matcher.matches();
        return result;
    }

    private static boolean matchesTrue(String lcText) {
        assert (lcText != null);
        Matcher matcher = truePattern.matcher(lcText);
        boolean result = matcher.matches();
        return result;
    }

    private String notABoolean() {
        if (this.allowNull.equals((Object)AllowNull.Yes)) {
            return "must be true, false, or null";
        }
        return "must be true or false";
    }
}

