/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.displaysettings;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.controls.ActionListener;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.screen.Screen;
import java.awt.DisplayMode;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.DsUtils;
import jme3utilities.InitialState;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.RectSizeLimits;
import jme3utilities.nifty.GuiScreenController;
import jme3utilities.nifty.PopupMenuBuilder;
import jme3utilities.nifty.dialog.DisplaySizeDialog;
import jme3utilities.nifty.displaysettings.DsInputMode;
import jme3utilities.ui.ActionApplication;
import jme3utilities.ui.DisplaySettings;
import jme3utilities.ui.InputMode;

public class DsScreen
extends GuiScreenController
implements ActionListener {
    static final Logger logger = Logger.getLogger(DsScreen.class.getName());
    public static final String apSelectColorDepth = "select colorDepth ";
    public static final String apSelectMsaaFactor = "select msaaFactor ";
    public static final String apSetDimensions = "set dimensions ";
    public static final String apSetRefreshRate = "set refreshRate ";
    public static final String name = "ds";
    private final DisplaySettings displaySettings;
    private final DsInputMode inputMode;
    private InputMode returnMode = null;

    public DsScreen(DisplaySettings ds) {
        super(name, "Interface/Nifty/screens/ds.xml", InitialState.Disabled);
        this.displaySettings = ds;
        this.inputMode = new DsInputMode(this);
        this.setListener((ActionListener)this.inputMode);
        this.influence((AppState)this.inputMode);
        this.inputMode.influence((AppState)this);
        assert (!this.isEnabled());
        assert (!this.isInitialized());
    }

    public void activate() {
        assert (!this.isEnabled());
        assert (this.isInitialized());
        assert (this.returnMode == null);
        this.returnMode = InputMode.getActiveMode();
        assert (this.returnMode != this.inputMode);
        assert (this.returnMode.isEnabled());
        this.returnMode.setEnabled(false);
        this.setEnabled(true);
    }

    @Override
    @NiftyEventSubscriber(pattern=".*CheckBox")
    public void onCheckBoxChanged(String checkBoxId, CheckBoxStateChangedEvent event) {
        Validate.nonNull((Object)checkBoxId, (String)"check box id");
        Validate.nonNull((Object)event, (String)"event");
        Validate.require((boolean)checkBoxId.endsWith("CheckBox"), (String)"ID ends with CheckBox");
        if (!this.isIgnoreGuiChanges() && this.hasStarted()) {
            String checkBoxName = MyString.removeSuffix((String)checkBoxId, (String)"CheckBox");
            boolean isChecked = event.isChecked();
            switch (checkBoxName) {
                case "fullscreen": {
                    this.displaySettings.setFullscreen(isChecked);
                    break;
                }
                case "gammaCorrection": {
                    this.displaySettings.setGammaCorrection(isChecked);
                    break;
                }
                case "vSync": {
                    this.displaySettings.setVSync(isChecked);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(checkBoxId);
                }
            }
        }
    }

    public void selectColorDepth() {
        PopupMenuBuilder builder = new PopupMenuBuilder();
        int depth = this.displaySettings.colorDepth();
        if (this.displaySettings.isFullscreen()) {
            String desc;
            int modeDepth;
            int height = this.displaySettings.height();
            int width = this.displaySettings.width();
            List modes = DsUtils.listDisplayModes();
            for (DisplayMode mode : modes) {
                modeDepth = mode.getBitDepth();
                if (mode.getHeight() != height || mode.getWidth() != width || builder.hasItem(desc = Integer.toString(modeDepth))) continue;
                builder.add(desc);
            }
            if (builder.isEmpty()) {
                for (DisplayMode mode : modes) {
                    modeDepth = mode.getBitDepth();
                    desc = Integer.toString(modeDepth);
                    if (builder.hasItem(desc)) continue;
                    builder.add(desc);
                }
            }
            for (DisplayMode mode : modes) {
                String desc2;
                modeDepth = mode.getBitDepth();
                int modeHeight = mode.getHeight();
                int modeWidth = mode.getWidth();
                if (modeDepth < 16 || modeDepth == depth || modeHeight != height || modeWidth != width || builder.hasItem(desc2 = Integer.toString(modeDepth))) continue;
                builder.add(desc2);
            }
        }
        if (builder.isEmpty()) {
            builder.add("24");
        }
        this.showPopupMenu(apSelectColorDepth, builder);
    }

    public void selectDimensions() {
        PopupMenuBuilder builder = new PopupMenuBuilder();
        int depth = this.displaySettings.colorDepth();
        int rate = this.displaySettings.refreshRate();
        RectSizeLimits sizeLimits = this.displaySettings.getSizeLimits();
        List modes = DsUtils.listDisplayModes();
        for (DisplayMode mode : modes) {
            String desc;
            int modeRate;
            int modeDepth = mode.getBitDepth();
            if (modeDepth > 0 && depth > 0 && modeDepth != depth || (modeRate = mode.getRefreshRate()) > 0 && rate > 0 && modeRate != rate) continue;
            int height = mode.getHeight();
            int width = mode.getWidth();
            if (!sizeLimits.isInRange(width, height) || builder.hasItem(desc = DsUtils.describeDimensions((int)width, (int)height))) continue;
            builder.add(desc);
        }
        if (builder.isEmpty()) {
            for (DisplayMode mode : modes) {
                String desc;
                int height = mode.getHeight();
                int width = mode.getWidth();
                if (!sizeLimits.isInRange(width, height) || builder.hasItem(desc = DsUtils.describeDimensions((int)width, (int)height))) continue;
                builder.add(desc);
            }
        }
        this.showPopupMenu(apSetDimensions, builder);
    }

    public void selectMsaaFactor() {
        PopupMenuBuilder builder = new PopupMenuBuilder();
        int selectedFactor = this.displaySettings.msaaFactor();
        for (int factor = 1; factor <= 16; ++factor) {
            if (factor == selectedFactor) continue;
            String description = DsUtils.describeMsaaFactor((int)factor);
            builder.add(description);
        }
        this.showPopupMenu(apSelectMsaaFactor, builder);
    }

    public void selectRefreshRate() {
        int modeRate;
        String desc;
        if (!this.displaySettings.isFullscreen()) {
            return;
        }
        PopupMenuBuilder builder = new PopupMenuBuilder();
        int height = this.displaySettings.height();
        int width = this.displaySettings.width();
        List modes = DsUtils.listDisplayModes();
        for (DisplayMode mode : modes) {
            if (mode.getHeight() != height || mode.getWidth() != width || builder.hasItem(desc = Integer.toString(modeRate = mode.getRefreshRate()))) continue;
            builder.add(desc);
        }
        if (builder.isEmpty()) {
            for (DisplayMode mode : modes) {
                modeRate = mode.getRefreshRate();
                desc = Integer.toString(modeRate);
                if (builder.hasItem(desc)) continue;
                builder.add(desc);
            }
        }
        this.showPopupMenu(apSetRefreshRate, builder);
    }

    public void setDimensions() {
        int height = this.displaySettings.height();
        int width = this.displaySettings.width();
        String defaultText = DsUtils.describeDimensions((int)width, (int)height);
        RectSizeLimits sizeLimits = this.displaySettings.getSizeLimits();
        DisplaySizeDialog controller = new DisplaySizeDialog("Set", sizeLimits);
        this.closeAllPopups();
        this.showTextEntryDialog("Enter display dimensions in pixels:", defaultText, apSetDimensions, controller);
    }

    public void onAction(String actionString, boolean ongoing, float tpf) {
        if (ongoing) {
            logger.log(Level.INFO, "Got action {0}", MyString.quote((CharSequence)actionString));
        }
        boolean handled = false;
        ActionApplication app = this.getActionApplication();
        if (ongoing) {
            String firstWord;
            InputMode defaultMode = app.getDefaultInputMode();
            switch (actionString) {
                case "apply displaySettings": {
                    this.displaySettings.applyToContext();
                    return;
                }
                case "Screenshot": 
                case "SIMPLEAPP_HideStats": 
                case "SIMPLEAPP_Memory": {
                    defaultMode.onAction(actionString, ongoing, tpf);
                    return;
                }
                case "return": {
                    this.deactivate();
                    return;
                }
                case "save displaySettings": {
                    this.displaySettings.save();
                    return;
                }
            }
            String[] words = actionString.split(" ");
            switch (firstWord = words[0]) {
                case "select": {
                    handled = this.selectAction(actionString);
                    break;
                }
                case "set": {
                    handled = this.setAction(actionString);
                    break;
                }
            }
        }
        if (!handled) {
            app.onAction(actionString, ongoing, tpf);
        }
    }

    @Override
    public void initialize(AppStateManager stateManager, Application application) {
        assert (!this.isInitialized());
        assert (!this.isEnabled());
        this.inputMode.initialize(stateManager, application);
        super.initialize(stateManager, application);
    }

    @Override
    public void update(float tpf) {
        assert (this.isEnabled());
        super.update(tpf);
        Screen screen = this.getScreen();
        if (!screen.isBound()) {
            return;
        }
        boolean fullscreen = this.displaySettings.isFullscreen();
        this.setChecked("fullscreen", fullscreen);
        boolean gamma = this.displaySettings.isGammaCorrection();
        this.setChecked("gammaCorrection", gamma);
        boolean vSync = this.displaySettings.isVSync();
        this.setChecked("vSync", vSync);
        this.updateButtonTexts();
        String feedbackText = "";
        if (!this.displaySettings.areValid()) {
            feedbackText = this.displaySettings.feedbackValid();
        } else if (!this.displaySettings.canApply()) {
            feedbackText = this.displaySettings.feedbackApplicable();
        } else if (!this.displaySettings.areApplied()) {
            feedbackText = "There are unapplied changes.";
        } else if (!this.displaySettings.areSaved()) {
            feedbackText = "There are unsaved changes.";
        }
        Element feedbackElement = this.getScreen().findElementById("feedback");
        TextRenderer renderer = (TextRenderer)feedbackElement.getRenderer(TextRenderer.class);
        renderer.setText(feedbackText);
    }

    private void deactivate() {
        assert (this.isEnabled());
        assert (this.isInitialized());
        assert (this.returnMode != null);
        assert (this.returnMode != this.inputMode);
        assert (!this.returnMode.isEnabled());
        this.closeAllPopups();
        this.setEnabled(false);
        this.returnMode.setEnabled(true);
        this.returnMode = null;
    }

    private boolean selectAction(String actionString) {
        boolean handled = true;
        if (actionString.equals("select colorDepth")) {
            this.selectColorDepth();
        } else if (actionString.startsWith(apSelectColorDepth)) {
            String arg = MyString.remainder((String)actionString, (String)apSelectColorDepth);
            int bitsPerPixel = Integer.parseInt(arg);
            this.displaySettings.setColorDepth(bitsPerPixel);
        } else if (actionString.equals("select msaaFactor")) {
            this.selectMsaaFactor();
        } else if (actionString.startsWith(apSelectMsaaFactor)) {
            String arg = MyString.remainder((String)actionString, (String)apSelectMsaaFactor);
            int factor = 16;
            for (int f = 1; f <= 16; ++f) {
                String aaDescription = DsUtils.describeMsaaFactor((int)f);
                if (!arg.equals(aaDescription)) continue;
                factor = f;
                break;
            }
            this.displaySettings.setMsaaFactor(factor);
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean setAction(String actionString) {
        boolean handled = true;
        if (actionString.equals("set dimensions")) {
            if (this.displaySettings.isFullscreen()) {
                this.selectDimensions();
            } else {
                this.setDimensions();
            }
        } else if (actionString.startsWith(apSetDimensions)) {
            String arg = MyString.remainder((String)actionString, (String)apSetDimensions);
            String lcArg = arg.toLowerCase(Locale.ROOT);
            if ("min".equals(lcArg)) {
                this.displaySettings.setMinSize();
            } else if ("max".equals(lcArg)) {
                this.displaySettings.setMaxSize();
            } else {
                int[] wh = DsUtils.parseDimensions((String)lcArg);
                if (wh == null) {
                    handled = false;
                } else {
                    this.displaySettings.setDimensions(wh[0], wh[1]);
                }
            }
        } else if (actionString.equals("set refreshRate")) {
            this.selectRefreshRate();
        } else if (actionString.startsWith(apSetRefreshRate)) {
            String arg = MyString.remainder((String)actionString, (String)apSetRefreshRate);
            int hertz = Integer.parseInt(arg);
            this.displaySettings.setRefreshRate(hertz);
        } else {
            handled = false;
        }
        return handled;
    }

    private void toggleFullscreen() {
        int depth;
        int rate;
        boolean isFullScreen = this.displaySettings.isFullscreen();
        if (isFullScreen) {
            rate = 0;
            depth = -1;
            this.displaySettings.scaleSize(0.8f, 0.8f);
        } else {
            int height;
            int width;
            RectSizeLimits limits;
            DisplayMode mode = DsUtils.displayMode();
            rate = mode.getRefreshRate();
            if (rate <= 0) {
                rate = 60;
            }
            if ((depth = mode.getBitDepth()) <= 0) {
                depth = 24;
            }
            if ((limits = this.displaySettings.getSizeLimits()).isInRange(width = mode.getWidth(), height = mode.getHeight())) {
                this.displaySettings.setDimensions(width, height);
            }
        }
        this.displaySettings.setRefreshRate(rate);
        this.displaySettings.setColorDepth(depth);
        this.displaySettings.setFullscreen(!isFullScreen);
    }

    private void updateButtonTexts() {
        int width = this.displaySettings.width();
        int height = this.displaySettings.height();
        String dimensionsButton = DsUtils.describeDimensions((int)width, (int)height);
        this.setButtonText("displayDimensions", dimensionsButton);
        int msaaFactor = this.displaySettings.msaaFactor();
        String msaaButton = DsUtils.describeMsaaFactor((int)msaaFactor);
        this.setButtonText("displayMsaa", msaaButton);
        String refreshRateButton = "";
        boolean fullscreen = this.displaySettings.isFullscreen();
        if (fullscreen) {
            int refreshRate = this.displaySettings.refreshRate();
            refreshRateButton = refreshRate <= 0 ? "unknown" : String.format("%d Hz", refreshRate);
        }
        this.setButtonText("refreshRate", refreshRateButton);
        int colorDepth = this.displaySettings.colorDepth();
        String colorDepthButton = String.format("%d bpp", colorDepth);
        this.setButtonText("colorDepth", colorDepthButton);
        String applyButton = "";
        if (this.displaySettings.canApply() && !this.displaySettings.areApplied()) {
            applyButton = "Apply";
        }
        this.setButtonText("applyDisplaySettings", applyButton);
        String saveButton = "";
        if (this.displaySettings.areValid() && !this.displaySettings.areSaved()) {
            saveButton = "Save";
        }
        this.setButtonText("saveDisplaySettings", saveButton);
        InputMode defaultMode = this.getActionApplication().getDefaultInputMode();
        String returnLabel = String.format("Return to %s mode", MyString.quote((CharSequence)defaultMode.shortName()));
        this.setButtonText("return", returnLabel);
    }
}

