/*
 * Decompiled with CFR 0.152.
 */
package cz.advel.stack.instrument;

import cz.advel.stack.Stack;
import cz.advel.stack.instrument.CheckClass;
import cz.advel.stack.instrument.InstrumentClass;
import cz.advel.stack.instrument.StackGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

class Instrumenter {
    static final String STACK_NAME = Type.getInternalName(Stack.class);
    private final List<File> files;
    private final File destDir;
    private final String stackPackageName;
    private final String stackInternalName;
    private boolean disabled = false;
    private boolean singleThread = false;
    private boolean isolated = false;
    private final Set<String> stackTypes = new HashSet<String>();
    private File currentFile;
    private String currentMethod;
    private final Map<File, Set<String>> classMethods = new LinkedHashMap<File, Set<String>>();

    Instrumenter(List<File> files, File destDir, String stackPackageName) {
        this.files = files;
        this.destDir = destDir;
        this.stackPackageName = stackPackageName;
        this.stackInternalName = stackPackageName.replace('.', '/') + '/' + "$Stack";
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setSingleThread(boolean singleThread) {
        this.singleThread = singleThread;
    }

    public boolean isSingleThread() {
        return this.singleThread;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        CheckClass checkClass = new CheckClass(this);
        File stackFile = new File(this.destDir, this.getStackInternalName() + ".class");
        for (File file : this.files) {
            if (file.equals(stackFile) || !file.getName().endsWith(".class")) continue;
            this.currentFile = file;
            try (FileInputStream in = new FileInputStream(file);){
                ClassReader cr = new ClassReader((InputStream)in);
                cr.accept((ClassVisitor)checkClass, 0);
            }
        }
        for (Map.Entry entry : this.classMethods.entrySet()) {
            ClassWriter cw = new ClassWriter(3);
            InstrumentClass instrClass = new InstrumentClass((ClassVisitor)cw, this, (Set)entry.getValue());
            try (FileInputStream in = new FileInputStream((File)entry.getKey());){
                ClassReader cr = new ClassReader((InputStream)in);
                cr.accept((ClassVisitor)instrClass, 0);
            }
            try (FileOutputStream out = new FileOutputStream((File)entry.getKey());){
                out.write(cw.toByteArray());
            }
        }
        if (!this.isDisabled()) {
            String[] types = this.stackTypes.toArray(new String[this.stackTypes.size()]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(new File(this.destDir, this.stackPackageName.replace('.', '/') + "/$Stack.class"));){
                fileOutputStream.write(StackGenerator.generateStackClass(this, types));
            }
            if (!this.isSingleThread()) {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(this.destDir, this.stackPackageName.replace('.', '/') + "/$Stack$1.class"));
                fileOutputStream.write(StackGenerator.generateStackClass1(this));
                fileOutputStream.close();
            }
        }
        System.out.println("Stack instrumented " + this.classMethods.size() + " classes");
    }

    String getStackInternalName() {
        return this.stackInternalName;
    }

    void addStackType(String internalName) {
        this.stackTypes.add(internalName);
    }

    void setCurrentMethod(String name) {
        this.currentMethod = name;
    }

    void addInstrumentMethod() {
        Set<String> methods = this.classMethods.get(this.currentFile);
        if (methods == null) {
            methods = new HashSet<String>();
            this.classMethods.put(this.currentFile, methods);
        }
        methods.add(this.currentMethod);
    }

    static String mangleInternalName(String name) {
        return name.replace('/', '$');
    }
}

