/*
 * Decompiled with CFR 0.152.
 */
package com.skovalenko.geocoder.address_parser;

public abstract class UsAddress {
    static final String FIELD_SEPARATOR = "|";
    protected String streetNumber = "";
    protected String streetPreDir = "";
    protected String streetName = "";
    protected String streetType = "";
    protected String streetPostDir = "";
    protected String city = "";
    protected String state = "";
    protected String zip = "";
    protected String zip4 = "";
    protected String county = "";
    protected String country = "USA";
    private String fullStreet;

    public UsAddress() {
    }

    public UsAddress(String streetNumber, String streetPreDir, String streetName, String streetType, String streetPostDir, String city, String state, String zip, String zip4) {
        this.streetNumber = streetNumber == null ? "" : streetNumber.toUpperCase();
        this.streetPreDir = streetPreDir == null ? "" : streetPreDir.toUpperCase();
        this.streetName = streetName == null ? "" : streetName.toUpperCase();
        this.streetType = streetType == null ? "" : streetType.toUpperCase();
        this.streetPostDir = streetPostDir == null ? "" : streetPostDir.toUpperCase();
        this.city = city == null ? "" : city.toUpperCase();
        this.state = state == null ? "" : state.toUpperCase();
        this.zip = zip == null ? "" : zip.toUpperCase();
        this.zip4 = zip4 == null ? "" : zip4.toUpperCase();
    }

    public UsAddress(String streetNumber, String streetPreDir, String streetName, String streetType, String streetPostDir) {
        this(streetNumber, streetPreDir, streetName, streetType, streetPostDir, "", "", "", "");
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city != null ? city.toUpperCase() : "";
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state != null ? state.toUpperCase() : "";
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName != null ? streetName.toUpperCase() : "";
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public int intStreetNumber() {
        int intStreetNumber = -1;
        try {
            intStreetNumber = Integer.parseInt(this.streetNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intStreetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber != null ? streetNumber.toUpperCase() : "";
    }

    public String getStreetPostDir() {
        return this.streetPostDir;
    }

    public void setStreetPostDir(String streetPostDir) {
        this.streetPostDir = streetPostDir != null ? streetPostDir.toUpperCase() : "";
    }

    public String getStreetPreDir() {
        return this.streetPreDir;
    }

    public void setStreetPreDir(String streetPreDir) {
        this.streetPreDir = streetPreDir != null ? streetPreDir.toUpperCase() : "";
    }

    public String getStreetType() {
        return this.streetType;
    }

    public void setStreetType(String streetType) {
        this.streetType = streetType != null ? streetType.toUpperCase() : "";
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip != null ? zip.toUpperCase() : "";
    }

    public String getZip4() {
        return this.zip4;
    }

    public void setZip4(String zip4) {
        this.zip4 = zip4 != null ? zip4.toUpperCase() : "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.zip).append(FIELD_SEPARATOR).append(this.zip4).append(FIELD_SEPARATOR).append(this.state).append(FIELD_SEPARATOR).append(this.city).append(FIELD_SEPARATOR).append(this.streetNumber).append(FIELD_SEPARATOR).append(this.streetName).append(FIELD_SEPARATOR).append(this.streetPreDir).append(FIELD_SEPARATOR).append(this.streetType).append(FIELD_SEPARATOR).append(this.streetPostDir);
        return sb.toString();
    }

    protected static String getHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("Zip").append(FIELD_SEPARATOR).append("Zip4").append(FIELD_SEPARATOR).append("State").append(FIELD_SEPARATOR).append("City").append(FIELD_SEPARATOR).append("Street Number").append(FIELD_SEPARATOR).append("Street Name").append(FIELD_SEPARATOR).append("Street Pre Dir").append(FIELD_SEPARATOR).append("Street Type").append(FIELD_SEPARATOR).append("Street Post Dir");
        return sb.toString();
    }

    public boolean checkValid() {
        if (this.streetName.length() == 0) {
            return false;
        }
        if (this.streetNumber.length() == 0 || !this.streetNumber.matches("^\\d+$")) {
            return false;
        }
        return this.city.length() != 0 || this.zip.length() != 0;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county != null ? county.toUpperCase() : "";
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country != null ? country.toUpperCase() : "USA";
    }

    public String getFullZip() {
        StringBuilder builder = new StringBuilder();
        this.appendPortion(builder, this.getZip(), false);
        this.appendPortion(builder, this.getZip4(), true, "-");
        return builder.toString();
    }

    public String getFullStreet() {
        if (this.fullStreet != null) {
            return this.fullStreet;
        }
        StringBuilder builder = new StringBuilder();
        this.appendPortion(builder, this.getStreetNumber(), false);
        this.appendPortion(builder, this.getStreetPreDir());
        this.appendPortion(builder, this.getStreetName());
        this.appendPortion(builder, this.getStreetType());
        this.appendPortion(builder, this.getStreetPostDir());
        return builder.toString();
    }

    public void setFullStreet(String fullStreet) {
        this.fullStreet = fullStreet;
    }

    private void appendPortion(StringBuilder builder, String portion) {
        this.appendPortion(builder, portion, true);
    }

    private void appendPortion(StringBuilder builder, String portion, boolean insertDelimiter) {
        this.appendPortion(builder, portion, insertDelimiter, " ");
    }

    private void appendPortion(StringBuilder builder, String portion, boolean insertDelimiter, String delimiter) {
        if (this.isBlank(portion)) {
            return;
        }
        if (insertDelimiter && builder.length() > 0) {
            builder.append(delimiter);
        }
        builder.append(portion);
    }

    private boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public boolean equals(UsAddress address) {
        return this.streetNumber.equalsIgnoreCase(address.getStreetNumber()) && this.streetPreDir.equalsIgnoreCase(address.getStreetPreDir()) && this.streetName.equalsIgnoreCase(address.getStreetName()) && this.streetType.equalsIgnoreCase(address.getStreetType()) && this.streetPostDir.equalsIgnoreCase(address.getStreetPostDir()) && this.city.equalsIgnoreCase(address.getCity()) && this.state.equalsIgnoreCase(address.getState()) && this.zip.equalsIgnoreCase(address.getZip()) && this.zip4.equalsIgnoreCase(address.getZip4()) && this.county.equalsIgnoreCase(address.getCounty()) && this.country.equalsIgnoreCase(address.getCountry());
    }
}

