/*
 * Decompiled with CFR 0.152.
 */
package com.skovalenko.geocoder.address_parser.us;

public class FancyStreetNumberParser {
    private static final String STREET_NUMBER_DBL = "^\\s*\\d+\\s*(\\s|-)\\s*\\d+\\s+";
    private static final String STREET_NUMBER_FRC = "^\\s*\\d+\\s+\\d[/]\\d\\s*[aAbBcCdD]?\\s+";
    private static final String STREET_NUMBER_FRC2 = "^\\s*\\d+\\s*[/]\\s*\\d+\\s+";
    private static final String STREET_NUMBER_LETR = "^\\s*\\d+\\s*[-]?\\s*[aAbBcCdD]\\s+";
    private static final String STREET_NUMBER_BIS = "^\\s*\\d+\\s*[Bb][Ii][Ss]\\s+";
    private static final String STREET_NUMBER_ROMA = "^\\s*\\d+\\s*[-]?\\s*[IVXivx]+\\s+";
    private static final String STREET_NUMBER_ANUM = "^\\s*[a-zA-Z]+\\d+[a-zA-Z]?\\d*\\s+";
    private static final String STREET_NUMBER_NUMA = "^\\s*\\d+[a-zA-Z]\\d*[a-zA-Z]?\\s+";
    private static final String[] FANCY_STREET_NUMBER_PATTERNS = new String[]{"^\\s*\\d+\\s*(\\s|-)\\s*\\d+\\s+", "^\\s*\\d+\\s+\\d[/]\\d\\s*[aAbBcCdD]?\\s+", "^\\s*\\d+\\s*[/]\\s*\\d+\\s+", "^\\s*\\d+\\s*[-]?\\s*[aAbBcCdD]\\s+", "^\\s*\\d+\\s*[Bb][Ii][Ss]\\s+", "^\\s*\\d+\\s*[-]?\\s*[IVXivx]+\\s+", "^\\s*[a-zA-Z]+\\d+[a-zA-Z]?\\d*\\s+", "^\\s*\\d+[a-zA-Z]\\d*[a-zA-Z]?\\s+"};

    public static String parse(String source) {
        String result = FancyStreetNumberParser.handleNumberSign(source);
        for (int i = 0; i < FANCY_STREET_NUMBER_PATTERNS.length; ++i) {
            result = FancyStreetNumberParser.handleFancyStreetNumber(result, FANCY_STREET_NUMBER_PATTERNS[i]);
        }
        return result;
    }

    private static String handleFancyStreetNumber(String addressLine, String pattern) {
        if (addressLine.matches(pattern + ".+")) {
            String[] rightAddr = addressLine.split(pattern, 2);
            if (rightAddr.length == 0) {
                return addressLine;
            }
            String rightPart = rightAddr[rightAddr.length - 1];
            String streetNumber = FancyStreetNumberParser.findFirstNumber(addressLine.substring(0, addressLine.indexOf(rightPart)));
            if (streetNumber.length() > 0) {
                return streetNumber + " " + rightPart;
            }
        }
        return addressLine;
    }

    private static String findFirstNumber(String src) {
        StringBuffer sb = new StringBuffer();
        for (int ndx = 0; ndx < src.length(); ++ndx) {
            char chr = src.charAt(ndx);
            if (Character.isDigit(chr)) {
                sb.append(chr);
                continue;
            }
            if (sb.length() > 0) break;
        }
        return sb.toString();
    }

    private static String handleNumberSign(String addressLine) {
        if (addressLine.length() > 6) {
            return addressLine.substring(0, 4).replace('#', ' ') + addressLine.substring(4);
        }
        return addressLine;
    }
}

