/*
 * Decompiled with CFR 0.152.
 */
package com.skovalenko.geocoder.address_parser.us;

import com.skovalenko.geocoder.address_parser.us.AddressToken;
import com.skovalenko.geocoder.address_parser.us.NumberParser;
import com.skovalenko.geocoder.address_parser.us.ParsedNumber;
import com.skovalenko.geocoder.address_parser.us.ParserUtilities;
import com.skovalenko.geocoder.address_parser.us.UsAddressParserDataStrings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParserSteps {
    public static AddressToken[] findNumericWords(AddressToken[] addressTokens) {
        for (int x = 0; x < Math.min(1, addressTokens.length); ++x) {
            if (!UsAddressParserDataStrings.NUMERIC_WORDS.contains(addressTokens[x].getToken())) continue;
            addressTokens[x].setHint(AddressToken.HintTypes.HINT_NUMERIC_WORD);
        }
        return addressTokens;
    }

    public static AddressToken[] findDirection(AddressToken[] addressTokens) {
        for (int x = 0; x < addressTokens.length; ++x) {
            if (!UsAddressParserDataStrings.DIRECTION.containsKey(addressTokens[x].getToken()) || x == addressTokens.length - 1 && addressTokens.length < 4 && UsAddressParserDataStrings.STREET_NAMES_EXCL.contains(addressTokens[x].getToken())) continue;
            addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_DIRECTION);
        }
        return addressTokens;
    }

    public static AddressToken[] findSubUnitType(AddressToken[] addressTokens) {
        for (int x = 0; x < addressTokens.length; ++x) {
            if (!UsAddressParserDataStrings.SU_TYPES.containsKey(addressTokens[x].getToken()) || x == addressTokens.length - 1 && addressTokens.length < 4 && UsAddressParserDataStrings.STREET_NAMES_EXCL.contains(addressTokens[x].getToken())) continue;
            addressTokens[x].setHint(AddressToken.HintTypes.HINT_SU_TYPE);
        }
        return addressTokens;
    }

    public static AddressToken[] findStreetType(AddressToken[] addressTokens) {
        for (int x = addressTokens.length - 1; x > 1; --x) {
            if (!UsAddressParserDataStrings.STREET_TYPE.containsKey(addressTokens[x].getToken())) continue;
            addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_TYPE);
            return addressTokens;
        }
        if (UsAddressParserDataStrings.ROUTE_ALIASES.contains(addressTokens[addressTokens.length - 1].getToken()) && addressTokens.length > 2) {
            addressTokens[addressTokens.length - 1].setHint(AddressToken.HintTypes.HINT_STREET_TYPE);
            addressTokens[addressTokens.length - 1].setToken("RTE");
            return addressTokens;
        }
        return addressTokens;
    }

    public static AddressToken[] groupNumericWordFields(AddressToken[] addressTokens) {
        List<AddressToken> at = ParserSteps.listFromArray(addressTokens);
        for (int x = 0; x < at.size(); ++x) {
            if (at.get(x).getHint() != AddressToken.HintTypes.HINT_NUMERIC_WORD) continue;
            String nextField = "";
            for (int y = x + 1; y < at.size() && at.get(y).getHint() == AddressToken.HintTypes.HINT_NUMERIC_WORD; ++y) {
                nextField = nextField + at.get(y).getToken() + " ";
                at.remove(y);
                --y;
            }
            at.get(x).setToken(at.get(x).getToken() + " " + nextField.trim());
            ParsedNumber pn = NumberParser.parseAlphabeticNumber(at.get(x).getToken());
            at.get(x).setToken(String.valueOf(pn.getNumber()) + pn.getSuffix());
            at.get(x).setHint(AddressToken.HintTypes.HINT_NUMERIC_WORD);
        }
        AddressToken[] newAt = new AddressToken[at.size()];
        return at.toArray(newAt);
    }

    public static AddressToken[] identifyStreetName(AddressToken[] addressTokens) {
        for (int x = addressTokens.length - 1; x > 0; --x) {
            if (addressTokens[x].getHint() != AddressToken.HintTypes.HINT_STREET_TYPE) continue;
            addressTokens[x - 1].setHint(AddressToken.HintTypes.HINT_STREET_NAME);
            return addressTokens;
        }
        return addressTokens;
    }

    public static AddressToken[] categorizeNumbers(AddressToken[] addressTokens) {
        for (int x = 0; x < addressTokens.length; ++x) {
            if (!addressTokens[x].isPartialNumeric()) continue;
            if (x > 0) {
                if (addressTokens[x - 1].getHint() == AddressToken.HintTypes.HINT_CITY | addressTokens[x - 1].getHint() == AddressToken.HintTypes.HINT_STATE) {
                    if (addressTokens[x].getToken().length() != 5) continue;
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_ZIP);
                    continue;
                }
                if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_STREET_NAME) {
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_NAME);
                    continue;
                }
                if (addressTokens[x - 1].getHint() == AddressToken.HintTypes.HINT_ZIP) {
                    if (addressTokens[x].getToken().length() != 4) continue;
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_ZIP4);
                    continue;
                }
                if (addressTokens[x - 1].getHint() == AddressToken.HintTypes.HINT_SU_TYPE) {
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_SU_NUMBER);
                    continue;
                }
                if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_NUMERIC_WORD) {
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_NONE);
                    continue;
                }
                if (x < addressTokens.length - 1) {
                    if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_SU_TYPE) {
                        addressTokens[x + 1].setHint(AddressToken.HintTypes.HINT_SU_NUMBER);
                        continue;
                    }
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_NUMBER);
                    continue;
                }
                addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_NUMBER);
                continue;
            }
            if (x != 0) continue;
            addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_NUMBER);
        }
        return addressTokens;
    }

    public static AddressToken[] groupStreetNumbers(AddressToken[] addressTokens) {
        List<AddressToken> at = ParserSteps.listFromArray(addressTokens);
        for (int x = 0; x < at.size(); ++x) {
            if (at.get(x).getHint() != AddressToken.HintTypes.HINT_STREET_NUMBER) continue;
            String nextField = "";
            for (int y = x + 1; y < at.size() && at.get(y).getHint() == AddressToken.HintTypes.HINT_STREET_NUMBER; ++y) {
                nextField = nextField + at.get(y).getToken();
                at.remove(y);
                --y;
            }
            at.get(x).setToken(at.get(x).getToken() + nextField.trim());
        }
        AddressToken[] newAt = new AddressToken[at.size()];
        return at.toArray(newAt);
    }

    public static AddressToken[] removeDuplicateStreetNumbers(AddressToken[] addressTokens) {
        boolean streetNumberFound = false;
        for (int x = 0; x < addressTokens.length; ++x) {
            if (addressTokens[x].getHint() != AddressToken.HintTypes.HINT_STREET_NUMBER) continue;
            if (streetNumberFound) {
                addressTokens[x].setHint(AddressToken.HintTypes.HINT_NONE);
                continue;
            }
            streetNumberFound = true;
        }
        return addressTokens;
    }

    public static AddressToken[] groupNoHits(AddressToken[] addressTokens) {
        int lastStreetName = ParserUtilities.findLastHintPosition(addressTokens, AddressToken.HintTypes.HINT_STREET_NAME);
        List<AddressToken> at = ParserSteps.listFromArray(addressTokens);
        for (int x = 0; x < at.size(); ++x) {
            if (at.get(x).getHint() != AddressToken.HintTypes.HINT_NONE) continue;
            String nextField = "";
            for (int y = x + 1; y < at.size(); ++y) {
                if (at.get(y).getHint() == AddressToken.HintTypes.HINT_NONE) {
                    nextField = nextField + at.get(y).getToken() + " ";
                    at.remove(y);
                    --y;
                    --lastStreetName;
                    continue;
                }
                if (at.get(y).getHint() != AddressToken.HintTypes.HINT_STREET_DIRECTION || y >= lastStreetName) break;
                while (y <= lastStreetName && y < at.size()) {
                    nextField = nextField + at.get(y).getToken() + " ";
                    at.remove(y);
                    --y;
                    --lastStreetName;
                    ++y;
                }
                break;
            }
            at.get(x).setToken(at.get(x).getToken() + " " + nextField.trim());
        }
        AddressToken[] newAt = new AddressToken[at.size()];
        return at.toArray(newAt);
    }

    public static AddressToken[] categorizeNoHits(AddressToken[] addressTokens) {
        int streetTypePos = ParserUtilities.findFirstHintPosition(addressTokens, AddressToken.HintTypes.HINT_STREET_TYPE);
        if (streetTypePos == -1) {
            streetTypePos = addressTokens.length - 1;
        }
        for (int x = 0; x < addressTokens.length; ++x) {
            if (addressTokens[x].getHint() != AddressToken.HintTypes.HINT_NONE) continue;
            if (x <= streetTypePos) {
                addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_NAME);
                continue;
            }
            addressTokens[x].setHint(AddressToken.HintTypes.HINT_SU_NUMBER);
        }
        return addressTokens;
    }

    public static AddressToken[] identifyDirection(AddressToken[] addressTokens) {
        boolean foundStreetNameOrType = false;
        for (int x = 0; x < addressTokens.length; ++x) {
            if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_STREET_DIRECTION) {
                if (foundStreetNameOrType) {
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_POSTDIR);
                    continue;
                }
                addressTokens[x].setHint(AddressToken.HintTypes.HINT_STREET_PREDIR);
                continue;
            }
            if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_STREET_NAME) {
                foundStreetNameOrType = true;
                continue;
            }
            if (addressTokens[x].getHint() != AddressToken.HintTypes.HINT_STREET_TYPE) continue;
            foundStreetNameOrType = true;
        }
        return addressTokens;
    }

    public static AddressToken[] trimTokens(AddressToken[] addressTokens) {
        for (int x = 0; x < addressTokens.length; ++x) {
            addressTokens[x].setToken(addressTokens[x].getToken().trim());
        }
        return addressTokens;
    }

    public static AddressToken[] fixBadMatches(AddressToken[] addressTokens) {
        if (ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_STREET_NAME) == "") {
            for (int x = 0; x < addressTokens.length; ++x) {
                if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_STREET_TYPE) {
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_NONE);
                }
                if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_STREET_POSTDIR) {
                    addressTokens[x].setHint(AddressToken.HintTypes.HINT_NONE);
                }
                if (addressTokens[x].getHint() != AddressToken.HintTypes.HINT_SU_NUMBER) continue;
                addressTokens[x].setHint(AddressToken.HintTypes.HINT_NONE);
            }
        }
        return addressTokens;
    }

    private static List<AddressToken> listFromArray(AddressToken[] addressToken) {
        ArrayList<AddressToken> at = new ArrayList<AddressToken>(addressToken.length);
        at.addAll(Arrays.asList(addressToken));
        return at;
    }

    public static AddressToken[] mergeStreetNames(AddressToken[] addressTokens) {
        String streetName = "";
        int numberOfNameTokens = 0;
        for (int x = 0; x < addressTokens.length; ++x) {
            if (addressTokens[x].getHint() != AddressToken.HintTypes.HINT_STREET_NAME) continue;
            ++numberOfNameTokens;
            streetName = streetName + addressTokens[x].getToken() + " ";
        }
        if (numberOfNameTokens > 1) {
            streetName = streetName.trim();
            AddressToken[] newTokens = new AddressToken[addressTokens.length + 1 - numberOfNameTokens];
            int newTokensIdx = 0;
            boolean first = true;
            for (int x = 0; x < addressTokens.length; ++x) {
                if (addressTokens[x].getHint() == AddressToken.HintTypes.HINT_STREET_NAME) {
                    if (first) {
                        first = false;
                        newTokens[newTokensIdx] = new AddressToken(streetName);
                        newTokens[newTokensIdx].setHint(AddressToken.HintTypes.HINT_STREET_NAME);
                    } else {
                        --newTokensIdx;
                    }
                } else {
                    newTokens[newTokensIdx] = addressTokens[x];
                }
                ++newTokensIdx;
            }
            return newTokens;
        }
        return addressTokens;
    }
}

