/*
 * Decompiled with CFR 0.152.
 */
package com.skovalenko.geocoder.address_parser.us;

import com.skovalenko.geocoder.address_parser.ParsedUsAddress;
import com.skovalenko.geocoder.address_parser.UnparsedAddress;
import com.skovalenko.geocoder.address_parser.us.AddressToken;
import com.skovalenko.geocoder.address_parser.us.FancyStreetNumberParser;
import com.skovalenko.geocoder.address_parser.us.ParserSteps;
import com.skovalenko.geocoder.address_parser.us.ParserUtilities;
import com.skovalenko.geocoder.address_parser.us.UsAddressParserDataStrings;

public class UsAddressParser {
    public ParsedUsAddress parse(UnparsedAddress unparsed) {
        String _zip = ParserUtilities.parseZip(unparsed.getZip());
        String _city = ParserUtilities.parseCity(unparsed.getCity());
        String _address = FancyStreetNumberParser.parse(unparsed.getAddressLine());
        _address = ParserUtilities.normalizeAddressLine(_address);
        ParsedUsAddress pa = UsAddressParser.parseAddressLine(_address);
        if (_zip != null) {
            pa.setZip(_zip);
        }
        if (_city != null) {
            pa.setCity(_city);
        }
        return UsAddressParser.standardize(pa);
    }

    private static ParsedUsAddress parseAddressLine(String address) {
        ParsedUsAddress parsedAddress = new ParsedUsAddress();
        AddressToken[] addressTokens = UsAddressParser.tokenizeAddressString(address);
        addressTokens = UsAddressParser.setTokenHints(addressTokens);
        parsedAddress.setStreetNumber(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_STREET_NUMBER));
        parsedAddress.setStreetPreDir(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_STREET_PREDIR));
        parsedAddress.setStreetName(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_STREET_NAME));
        parsedAddress.setStreetType(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_STREET_TYPE));
        parsedAddress.setStreetPostDir(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_STREET_POSTDIR));
        parsedAddress.setSubUnitNumber(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_SU_NUMBER));
        parsedAddress.setSubUnitName(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_SU_TYPE));
        parsedAddress.setCity(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_CITY));
        parsedAddress.setState(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_STATE));
        parsedAddress.setZip(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_ZIP));
        parsedAddress.setZip4(ParserUtilities.getValueFromTokens(addressTokens, AddressToken.HintTypes.HINT_ZIP4));
        return parsedAddress;
    }

    private static AddressToken[] tokenizeAddressString(String cleanAddress) {
        String[] addressFields = cleanAddress.split(" ");
        AddressToken[] addressTokens = new AddressToken[addressFields.length];
        for (int x = 0; x < addressFields.length; ++x) {
            AddressToken token;
            addressTokens[x] = token = new AddressToken(addressFields[x]);
        }
        return addressTokens;
    }

    private static AddressToken[] setTokenHints(AddressToken[] addressTokens) {
        addressTokens = ParserSteps.findNumericWords(addressTokens);
        addressTokens = ParserSteps.findDirection(addressTokens);
        addressTokens = ParserSteps.findSubUnitType(addressTokens);
        addressTokens = ParserSteps.findStreetType(addressTokens);
        addressTokens = ParserSteps.groupNumericWordFields(addressTokens);
        addressTokens = ParserSteps.identifyStreetName(addressTokens);
        addressTokens = ParserSteps.categorizeNumbers(addressTokens);
        addressTokens = ParserSteps.groupStreetNumbers(addressTokens);
        addressTokens = ParserSteps.removeDuplicateStreetNumbers(addressTokens);
        addressTokens = ParserSteps.groupNoHits(addressTokens);
        addressTokens = ParserSteps.categorizeNoHits(addressTokens);
        addressTokens = ParserSteps.identifyDirection(addressTokens);
        addressTokens = ParserSteps.trimTokens(addressTokens);
        addressTokens = ParserSteps.fixBadMatches(addressTokens);
        addressTokens = ParserSteps.mergeStreetNames(addressTokens);
        return addressTokens;
    }

    private static ParsedUsAddress standardize(ParsedUsAddress address) {
        String streetType;
        String standardDir = UsAddressParserDataStrings.DIRECTION.get(address.getStreetPreDir());
        if (standardDir != null) {
            address.setStreetPreDir(standardDir);
        }
        if ((streetType = UsAddressParserDataStrings.STREET_TYPE.get(address.getStreetType())) != null) {
            address.setStreetType(streetType);
        }
        return address;
    }
}

