/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.openclassic.api.block;

import com.github.steveice10.openclassic.api.Position;
import com.github.steveice10.openclassic.api.block.BlockFace;
import com.github.steveice10.openclassic.api.block.BlockType;

public class Block {
    private Position pos;

    public Block(Position pos) {
        this.pos = pos;
    }

    public byte getTypeId() {
        return this.pos.getLevel().getBlockIdAt(this.pos);
    }

    public void setTypeId(byte id) {
        this.pos.getLevel().setBlockIdAt(this.pos, id);
    }

    public BlockType getType() {
        return BlockType.fromId(this.getTypeId());
    }

    public void setType(BlockType block) {
        this.setTypeId(block.getId());
    }

    public Position getPosition() {
        return this.pos;
    }

    public Block getRelative(BlockFace face) {
        Position pos = this.pos.clone().add(face.getModX(), face.getModY(), face.getModZ());
        if (pos.getBlockX() >= this.pos.getLevel().getWidth() || pos.getBlockX() < 0) {
            return null;
        }
        if (pos.getBlockY() >= this.pos.getLevel().getHeight() || pos.getBlockY() < 0) {
            return null;
        }
        if (pos.getBlockZ() >= this.pos.getLevel().getDepth() || pos.getBlockZ() < 0) {
            return null;
        }
        return new Block(pos);
    }
}

