/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.openclassic.api.config;

import com.github.steveice10.openclassic.api.MathHelper;
import com.github.steveice10.openclassic.api.config.Configuration;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationNode {
    private final String path;
    protected Configuration config;
    private Object value;
    private Object def;

    public ConfigurationNode(String path, Object def) {
        this.path = path;
        this.def = def;
        this.value = def;
    }

    public String getPath() {
        return this.path;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        this.setValue(this.def, true);
        return this.def;
    }

    public void setValue(Object value, boolean toMemoryConfig) {
        this.value = value;
        if (this.config != null && toMemoryConfig) {
            this.config.addNode(this);
        }
    }

    public void setDefaultValue(Object def) {
        this.def = def;
        if (this.value == null) {
            this.value = def;
        }
    }

    public void setConfiguration(Configuration config) {
        config.addNode(this);
    }

    public String getString() {
        return this.getString(null);
    }

    public String getString(String def) {
        if (this.value != null) {
            return this.value.toString();
        }
        this.setValue(def, true);
        return def;
    }

    public int getInteger() {
        return this.getInteger(0);
    }

    public int getInteger(int def) {
        Integer i = MathHelper.castInt(this.value);
        if (i != null) {
            return i;
        }
        if (this.value == null) {
            this.setValue(def, true);
        }
        return def;
    }

    public double getDouble() {
        return this.getDouble(0.0);
    }

    public double getDouble(double def) {
        Double d = MathHelper.castDouble(this.value);
        if (d != null) {
            return d;
        }
        if (this.value == null) {
            this.setValue(def, true);
        }
        return def;
    }

    public float getFloat() {
        return this.getFloat(0.0f);
    }

    public float getFloat(float def) {
        Float f = MathHelper.castFloat(this.value);
        if (f != null) {
            return f.floatValue();
        }
        if (this.value == null) {
            this.setValue(Float.valueOf(def), true);
        }
        return def;
    }

    public boolean getBoolean() {
        return this.getBoolean(false);
    }

    public boolean getBoolean(boolean def) {
        Boolean b = MathHelper.castBoolean(this.value);
        if (b != null) {
            return b;
        }
        if (this.value == null) {
            this.setValue(def, true);
        }
        return def;
    }

    public List<Object> getList() {
        return this.getList(null);
    }

    public List<Object> getList(List<Object> def) {
        if (this.value != null && this.value instanceof List) {
            return (List)this.value;
        }
        if (this.value == null) {
            this.setValue(def, true);
        }
        return def;
    }

    public List<String> getStringList() {
        return this.getStringList(null);
    }

    public List<String> getStringList(List<String> def) {
        List<Object> raw = this.getList();
        if (raw != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object obj : raw) {
                list.add(obj.toString());
            }
            return list;
        }
        return def;
    }

    public List<Integer> getIntegerList() {
        return this.getIntegerList(null);
    }

    public List<Integer> getIntegerList(List<Integer> def) {
        List<Object> raw = this.getList();
        if (raw != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Object o : raw) {
                Integer i = MathHelper.castInt(o);
                if (i == null) continue;
                list.add(i);
            }
            return list;
        }
        return def;
    }

    public List<Double> getDoubleList() {
        return this.getDoubleList(null);
    }

    public List<Double> getDoubleList(List<Double> def) {
        List<Object> raw = this.getList();
        if (raw != null) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Object o : raw) {
                Double i = MathHelper.castDouble(o);
                if (i == null) continue;
                list.add(i);
            }
            return list;
        }
        return def;
    }

    public List<Boolean> getBooleanList() {
        return this.getBooleanList(null);
    }

    public List<Boolean> getBooleanList(List<Boolean> def) {
        List<Object> raw = this.getList();
        if (raw != null) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (Object o : raw) {
                Boolean b = MathHelper.castBoolean(o);
                if (b == null) continue;
                list.add(b);
            }
            return list;
        }
        return def;
    }
}

