/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.openclassic.api.plugin;

import com.github.steveice10.openclassic.api.config.Configuration;
import com.github.steveice10.openclassic.api.event.Listener;
import com.github.steveice10.openclassic.api.plugin.PluginDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plugin {
    private PluginDescription description;
    private Configuration config;
    private File dataFolder;
    private boolean enabled;
    private List<Listener> listeners = new ArrayList<Listener>();

    public Plugin(PluginDescription description) {
        this.description = description;
        this.dataFolder = new File("plugins/" + description.getName());
        this.config = new Configuration(new File(this.dataFolder, "config.yml"));
    }

    public abstract void onEnable();

    public abstract void onDisable();

    public PluginDescription getDescription() {
        return this.description;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    protected void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }
}

