/*
 * Decompiled with CFR 0.152.
 */
package com.github.stuxuhai.jpinyin;

import com.github.stuxuhai.jpinyin.PinyinResource;
import java.util.Map;

public final class ChineseHelper {
    private static final String CHINESE_REGEX = "[\\u4e00-\\u9fa5]";
    private static final Map<String, String> CHINESE_MAP = PinyinResource.getChineseResource();

    private ChineseHelper() {
    }

    public static char convertToSimplifiedChinese(char c) {
        String simplifiedChinese = CHINESE_MAP.get(String.valueOf(c));
        if (simplifiedChinese != null) {
            return simplifiedChinese.charAt(0);
        }
        return c;
    }

    public static char convertToTraditionalChinese(char c) {
        String simplifiedChinese = String.valueOf(c);
        for (Map.Entry<String, String> entry : CHINESE_MAP.entrySet()) {
            if (!entry.getValue().equals(simplifiedChinese)) continue;
            return entry.getKey().charAt(0);
        }
        return c;
    }

    public static String convertToSimplifiedChinese(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            sb.append(ChineseHelper.convertToSimplifiedChinese(c));
        }
        return sb.toString();
    }

    public static String convertToTraditionalChinese(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            sb.append(ChineseHelper.convertToTraditionalChinese(c));
        }
        return sb.toString();
    }

    public static boolean isTraditionalChinese(char c) {
        return CHINESE_MAP.containsKey(String.valueOf(c));
    }

    public static boolean isChinese(char c) {
        return '\u3007' == c || String.valueOf(c).matches(CHINESE_REGEX);
    }

    public static boolean containsChinese(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!ChineseHelper.isChinese(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

