/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Setting;
import com.github.sulir.edigen.Translator;
import com.github.sulir.edigen.parser.ParseException;
import com.github.sulir.edigen.ui.Argument;
import com.github.sulir.edigen.ui.CommandLine;
import com.github.sulir.edigen.ui.CommandLineException;
import com.github.sulir.edigen.ui.Help;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public class Edigen {
    private static final Argument[] ARGUMENTS = new Argument[]{new Argument("<specification> - File containing the description of instructions", Setting.SPECIFICATION), new Argument("<decoder> - Resulting instruction decoder package + class name", Setting.DECODER_NAME), new Argument("<disassembler> - Resulting disassembler package + class name", Setting.DISASSEMBLER_NAME), new Argument("ao", "Write generated disassembler file to <directory>", Setting.DISASSEMBLER_DIRECTORY), new Argument("at", "Use <template> for disassembler instead of the default one", Setting.DISASSEMBLER_TEMPLATE), new Argument("d", "Enable debug mode", Setting.DEBUG), new Argument("do", "Write generated decoder file to <directory>", Setting.DECODER_DIRECTORY), new Argument("dt", "Use <template> for decoder instead of the default one", Setting.DECODER_TEMPLATE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean success = false;
        try {
            new Edigen().run(args);
            success = true;
        }
        catch (CommandLineException ex) {
            if (args.length == 0) {
                success = true;
            } else {
                System.out.println("\nError: " + ex.getMessage() + ".\n");
            }
            Help help = new Help("java -jar edigen.jar", new CommandLine(ARGUMENTS));
            System.out.print(help.generate());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Could not open file: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println("Error during file manipulation: " + ex.getMessage());
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
        }
        catch (SemanticException ex) {
            System.out.println("Error: " + ex.getMessage() + ".");
        }
        finally {
            if (!success) {
                System.exit(1);
            }
        }
    }

    public void run(String[] args) throws CommandLineException, IOException, ParseException, SemanticException {
        System.out.println("Edigen - Emulator Disassembler Generator");
        CommandLine commandLine = new CommandLine(ARGUMENTS);
        Map<Setting, String> configuration = commandLine.parse(args);
        new Translator(configuration).translate();
        System.out.println("Instruction decoder and disassembler successfully generated.");
    }
}

