/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Setting;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.generation.DecoderGenerator;
import com.github.sulir.edigen.generation.DisassemblerGenerator;
import com.github.sulir.edigen.nodes.Specification;
import com.github.sulir.edigen.parser.ParseException;
import com.github.sulir.edigen.parser.Parser;
import com.github.sulir.edigen.passes.DetectAmbiguousVisitor;
import com.github.sulir.edigen.passes.GroupVisitor;
import com.github.sulir.edigen.passes.JoinVisitor;
import com.github.sulir.edigen.passes.MoveMasksVisitor;
import com.github.sulir.edigen.passes.MoveVariantsVisitor;
import com.github.sulir.edigen.passes.RemovePatternsVisitor;
import com.github.sulir.edigen.passes.ResolveNamesVisitor;
import com.github.sulir.edigen.passes.SemanticCheckVisitor;
import com.github.sulir.edigen.passes.SortVisitor;
import com.github.sulir.edigen.passes.SplitVisitor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;

public class Translator {
    private static final PrintStream DEBUG_STREAM = System.out;
    private final Map<Setting, String> settings;

    public Translator(Map<Setting, String> settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate() throws IOException, ParseException, SemanticException {
        try (BufferedReader input = null;){
            input = new BufferedReader(new FileReader(this.settings.get((Object)Setting.SPECIFICATION)));
            Parser parser = new Parser(input);
            Specification specification = parser.parse();
            this.transform(specification);
            DecoderGenerator decoder = new DecoderGenerator(specification.getDecoder(), this.settings.get((Object)Setting.DECODER_NAME));
            decoder.setOutputDirectory(this.settings.get((Object)Setting.DECODER_DIRECTORY));
            decoder.setTemplateFile(this.settings.get((Object)Setting.DECODER_TEMPLATE));
            decoder.generate();
            DisassemblerGenerator disassembler = new DisassemblerGenerator(specification.getDisassembler(), this.settings.get((Object)Setting.DISASSEMBLER_NAME), this.settings.get((Object)Setting.DECODER_NAME));
            disassembler.setOutputDirectory(this.settings.get((Object)Setting.DISASSEMBLER_DIRECTORY));
            disassembler.setTemplateFile(this.settings.get((Object)Setting.DISASSEMBLER_TEMPLATE));
            disassembler.generate();
        }
    }

    private void transform(Specification specification) throws SemanticException {
        Visitor[] transforms = new Visitor[]{new ResolveNamesVisitor(), new SemanticCheckVisitor(), new JoinVisitor(), new SortVisitor(), new SplitVisitor(), new MoveVariantsVisitor(), new GroupVisitor(), new DetectAmbiguousVisitor(), new MoveMasksVisitor(), new RemovePatternsVisitor()};
        if (this.settings.containsKey((Object)Setting.DEBUG)) {
            System.out.println("Debug mode is on. Tree dump:\n");
        }
        for (Visitor visitor : transforms) {
            specification.accept(visitor);
            if (!this.settings.containsKey((Object)Setting.DEBUG)) continue;
            specification.dump(DEBUG_STREAM);
        }
    }
}

