/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.generation;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.generation.GenerateFormatsVisitor;
import com.github.sulir.edigen.generation.GenerateParametersVisitor;
import com.github.sulir.edigen.generation.Generator;
import com.github.sulir.edigen.misc.Template;
import com.github.sulir.edigen.nodes.Disassembler;
import java.io.StringWriter;

public class DisassemblerGenerator
extends Generator {
    private final Disassembler disassembler;
    private final String decoderName;

    public DisassemblerGenerator(Disassembler disassembler, String disassemblerName, String decoderName) {
        super("/Disassembler.edt", disassemblerName);
        this.disassembler = disassembler;
        this.decoderName = decoderName;
    }

    @Override
    protected void fillTemplate(Template template) throws SemanticException {
        super.fillTemplate(template);
        template.setVariable("disasm_package", this.getPackageName());
        template.setVariable("disasm_class", this.getClassName());
        template.setVariable("decoder_name", this.decoderName);
        StringWriter formats = new StringWriter();
        this.disassembler.accept(new GenerateFormatsVisitor(formats));
        template.setVariable("disasm_formats", ((Object)formats).toString());
        StringWriter values = new StringWriter();
        this.disassembler.accept(new GenerateParametersVisitor(values));
        template.setVariable("disasm_parameters", ((Object)values).toString());
    }
}

