/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.generation;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.misc.PrettyPrinter;
import com.github.sulir.edigen.nodes.Decoder;
import com.github.sulir.edigen.nodes.Rule;
import com.github.sulir.edigen.nodes.Variant;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;

public class GenerateFieldsVisitor
extends Visitor {
    private final PrettyPrinter printer;
    private boolean ruleReturns;
    private final Set<String> fields = new LinkedHashSet<String>();

    public GenerateFieldsVisitor(Writer writer) {
        this.printer = new PrettyPrinter(writer);
    }

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        decoder.acceptChildren(this);
        int ruleNumber = 1;
        for (String field : this.fields) {
            this.printer.writeLine("public static final int " + field + " = " + ruleNumber++ + ";");
        }
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        this.ruleReturns = false;
        rule.acceptChildren(this);
        if (this.ruleReturns) {
            for (String name : rule.getNames()) {
                this.fields.add(rule.getFieldName(name));
            }
        }
    }

    @Override
    public void visit(Variant variant) {
        if (variant.getFieldName() != null) {
            this.fields.add(variant.getFieldName());
        }
        if (variant.returns()) {
            this.ruleReturns = true;
        }
    }
}

