/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.generation;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.misc.PrettyPrinter;
import com.github.sulir.edigen.nodes.Disassembler;
import com.github.sulir.edigen.nodes.Format;
import com.github.sulir.edigen.nodes.TreeNode;
import java.io.Writer;
import java.util.Iterator;

public class GenerateFormatsVisitor
extends Visitor {
    private final PrettyPrinter printer;
    private String formatString;

    public GenerateFormatsVisitor(Writer writer) {
        this.printer = new PrettyPrinter(writer);
    }

    @Override
    public void visit(Disassembler disassembler) throws SemanticException {
        Iterator<TreeNode> formats = disassembler.getChildren().iterator();
        while (formats.hasNext()) {
            formats.next().accept(this);
            String separator = formats.hasNext() ? ", " : "";
            this.printer.writeLine(this.formatString + separator);
        }
    }

    @Override
    public void visit(Format format) {
        this.formatString = '\"' + format.getFormatString() + '\"';
    }
}

