/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.generation;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.misc.PrettyPrinter;
import com.github.sulir.edigen.nodes.Mask;
import com.github.sulir.edigen.nodes.Pattern;
import com.github.sulir.edigen.nodes.Rule;
import com.github.sulir.edigen.nodes.Subrule;
import com.github.sulir.edigen.nodes.Variant;
import java.io.Writer;

public class GenerateMethodsVisitor
extends Visitor {
    private final PrettyPrinter printer;
    private Rule currentRule;
    private boolean isDefaultCase = false;

    public GenerateMethodsVisitor(Writer output) {
        this.printer = new PrettyPrinter(output);
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        this.currentRule = rule;
        this.isDefaultCase = false;
        String secondParameter = rule.hasOnlyOneName() ? "" : ", int rule";
        this.put("private void " + this.currentRule.getMethodName() + "(int start" + secondParameter + ") throws InvalidInstructionException {");
        rule.acceptChildren(this);
        this.put("}", true);
    }

    @Override
    public void visit(Mask mask) throws SemanticException {
        boolean isZero = mask.getBits().containsOnly(false);
        if (!this.isDefaultCase) {
            this.put("unit = read(start + " + mask.getStart() + ", " + mask.getBits().getLength() + ");", true);
        }
        this.isDefaultCase = false;
        if (!isZero) {
            this.put("switch (unit & 0x" + mask.getBits().toHexadecimal() + ") {");
        }
        mask.acceptChildren(this);
        if (!isZero && !this.isDefaultCase) {
            this.put("default:");
            this.put("throw new InvalidInstructionException();");
        }
        if (!isZero) {
            this.put("}");
        }
    }

    @Override
    public void visit(Pattern pattern) throws SemanticException {
        if (pattern.getBits().getLength() != 0) {
            this.put("case 0x" + pattern.getBits().toHexadecimal() + ":");
        } else {
            this.put("default:");
        }
        pattern.acceptChildren(this);
        this.put("break;");
        this.isDefaultCase = pattern.getBits().getLength() == 0;
    }

    @Override
    public void visit(Variant variant) throws SemanticException {
        if (variant.returns()) {
            String value;
            String field = "rule";
            if (this.currentRule.hasOnlyOneName()) {
                field = this.currentRule.getFieldName(this.currentRule.getNames().get(0));
            }
            if (variant.getReturnString() != null) {
                value = '\"' + variant.getReturnString() + "\", " + variant.getFieldName();
            } else {
                int start = variant.getReturnSubrule().getStart();
                int length = variant.getReturnSubrule().getLength();
                value = String.format("readBytes(start + %d, %d)", start, length);
            }
            this.put(String.format("instruction.add(%s, %s);", field, value));
        }
        variant.acceptChildren(this);
    }

    @Override
    public void visit(Subrule subrule) {
        String fieldToWrite = "";
        if (!subrule.getRule().hasOnlyOneName()) {
            fieldToWrite = ", " + subrule.getFieldName();
        }
        this.put(subrule.getRule().getMethodName() + "(start + " + subrule.getStart() + fieldToWrite + ");");
    }

    private void put(String lineOfCode, boolean newBlock) {
        this.printer.writeLine(lineOfCode);
        if (newBlock) {
            this.printer.writeLine("");
        }
    }

    private void put(String lineOfCode) {
        this.put(lineOfCode, false);
    }
}

