/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.generation;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.nodes.Disassembler;
import com.github.sulir.edigen.nodes.Format;
import com.github.sulir.edigen.nodes.TreeNode;
import com.github.sulir.edigen.nodes.Value;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class GenerateParametersVisitor
extends Visitor {
    private final PrintWriter writer;

    public GenerateParametersVisitor(Writer writer) {
        this.writer = new PrintWriter(writer, true);
    }

    @Override
    public void visit(Disassembler disassembler) throws SemanticException {
        Iterator<TreeNode> formats = disassembler.getChildren().iterator();
        while (formats.hasNext()) {
            formats.next().accept(this);
            if (!formats.hasNext()) continue;
            this.writer.println(",");
        }
    }

    @Override
    public void visit(Format format) throws SemanticException {
        this.writer.print("{");
        Iterator<TreeNode> values = format.getChildren().iterator();
        while (values.hasNext()) {
            values.next().accept(this);
            if (!values.hasNext()) continue;
            this.writer.println(",");
            this.writer.print(" ");
        }
        this.writer.print("}");
    }

    @Override
    public void visit(Value value) throws SemanticException {
        this.writer.print("new Parameter(" + value.getFieldName() + ", Strategy::" + value.getStrategy() + ")");
    }
}

