/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.generation;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.misc.Template;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class Generator {
    private final String defaultTemplate;
    private final String name;
    private String templateFile;
    private String outputDirectory;

    protected Generator(String defaultTemplate, String name) {
        this.defaultTemplate = defaultTemplate;
        this.name = name;
    }

    public String getPackageName() {
        int dotIndex = this.name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "edigen.cpu";
        }
        return this.name.substring(0, dotIndex);
    }

    public String getClassName() {
        int dotIndex = this.name.lastIndexOf(46);
        if (dotIndex == -1) {
            return this.name;
        }
        return this.name.substring(dotIndex + 1);
    }

    public void setTemplateFile(String templateFile) {
        this.templateFile = templateFile;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SemanticException {
        BufferedReader templateReader = null;
        BufferedWriter outputWriter = null;
        try {
            templateReader = this.openTemplate();
            outputWriter = this.openOutput();
            Template template = new Template(templateReader, outputWriter);
            this.fillTemplate(template);
            template.write();
        }
        finally {
            if (templateReader != null) {
                templateReader.close();
            }
            if (outputWriter != null) {
                outputWriter.close();
            }
        }
    }

    protected void fillTemplate(Template template) throws SemanticException {
        template.setVariable("auto_gen_warning", "/* Auto-generated file. Do not modify. */");
    }

    private BufferedReader openTemplate() throws FileNotFoundException {
        BufferedReader templateSource;
        if (this.templateFile != null) {
            templateSource = new BufferedReader(new FileReader(this.templateFile));
        } else {
            InputStream stream = this.getClass().getResourceAsStream(this.defaultTemplate);
            templateSource = new BufferedReader(new InputStreamReader(stream));
        }
        return templateSource;
    }

    private BufferedWriter openOutput() throws IOException {
        String outputFile = this.getClassName() + ".java";
        File outputPath = this.outputDirectory != null ? new File(this.outputDirectory, outputFile) : new File(outputFile);
        return new BufferedWriter(new FileWriter(outputPath));
    }
}

