/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Template {
    private static final String VARIABLE_NAME = "([A-Za-z_]\\w*)";
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("([A-Za-z_]\\w*)");
    private static final Pattern BLOCK_VARIABLE = Pattern.compile("(\\s*)%([A-Za-z_]\\w*)%(\\s*)");
    private static final Pattern INLINE_VARIABLE = Pattern.compile("%([A-Za-z_]\\w*)%");
    private static final Pattern LINE_START = Pattern.compile("^", 8);
    private final BufferedReader template;
    private final BufferedWriter output;
    private final Map<String, String> variables = new HashMap<String, String>();

    public Template(BufferedReader template, BufferedWriter output) {
        this.template = template;
        this.output = output;
    }

    public void setVariable(String name, String value) {
        if (!VARIABLE_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid variable name");
        }
        this.variables.put(name, value);
    }

    public void write() throws IOException {
        String line;
        while ((line = this.template.readLine()) != null) {
            Matcher blockVariable = BLOCK_VARIABLE.matcher(line);
            line = blockVariable.matches() ? this.replaceBlockVariable(blockVariable) : this.replaceInlineVariables(line);
            this.output.write(line);
            this.output.newLine();
        }
    }

    private String replaceBlockVariable(Matcher matcher) {
        String name = matcher.group(2);
        String value = this.variables.get(name);
        if (value != null) {
            String indentation = matcher.group(1);
            return LINE_START.matcher(value).replaceAll(indentation);
        }
        return matcher.group();
    }

    private String replaceInlineVariables(String line) {
        Matcher matcher = INLINE_VARIABLE.matcher(line);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = this.variables.get(name);
            if (value != null) {
                matcher.appendReplacement(result, value);
                continue;
            }
            matcher.appendReplacement(result, matcher.group());
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

