/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.nodes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.nodes.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Rule
extends TreeNode {
    private List<String> names = new ArrayList<String>();

    public Rule(List<String> names) {
        this.names = names;
    }

    public Rule(String name) {
        this.names = Collections.singletonList(name);
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    public boolean hasOnlyOneName() {
        return this.names.size() == 1;
    }

    public String getMethodName() {
        return this.names.get(0);
    }

    public String getFieldName(String ruleName) {
        return ruleName.toUpperCase();
    }

    public String getLabel() {
        Iterator<String> nameIterator = this.names.iterator();
        StringBuilder result = new StringBuilder();
        while (nameIterator.hasNext()) {
            result.append((Object)nameIterator.next());
            if (!nameIterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        return "Rule: " + this.getLabel();
    }
}

