/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.nodes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.nodes.Pattern;
import com.github.sulir.edigen.nodes.Rule;
import com.github.sulir.edigen.nodes.TreeNode;

public class Subrule
extends TreeNode {
    private String name;
    private Integer start;
    private Integer length;
    private Pattern prePattern;
    private Rule rule;

    public Subrule(String name) {
        this(name, null);
    }

    public Subrule(String name, Pattern prePattern) {
        this(name, null, prePattern);
    }

    public Subrule(String name, Integer length, Pattern prePattern) {
        this.name = name;
        this.length = length;
        this.prePattern = prePattern;
    }

    public String getName() {
        return this.name;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public Integer getLength() {
        return this.length;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Pattern getPrePattern() {
        return this.prePattern;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public String getFieldName() {
        return this.rule.getFieldName(this.name);
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Subrule: ");
        result.append(this.getName());
        if (this.start != null) {
            result.append(", start: ").append(this.start);
        }
        if (this.length != null) {
            result.append(", length: ").append(this.length);
        }
        return result.toString();
    }
}

