/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.nodes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class TreeNode {
    private TreeNode parent;
    private final Set<TreeNode> children = new LinkedHashSet<TreeNode>();
    private Integer line;

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChild(int index) {
        Iterator<TreeNode> iterator = this.children.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public Iterable<TreeNode> getChildren() {
        return new ArrayList<TreeNode>(this.children);
    }

    public int childCount() {
        return this.children.size();
    }

    public void addChild(TreeNode child) {
        child.parent = this;
        this.children.add(child);
    }

    public void addChildren(TreeNode ... children) {
        for (TreeNode child : children) {
            this.addChild(child);
        }
    }

    public void remove() {
        this.parent.children.remove(this);
        this.parent = null;
    }

    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public void acceptChildren(Visitor visitor) throws SemanticException {
        for (TreeNode child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public void dump(PrintStream outStream) {
        this.print(outStream, 0);
        outStream.println("---------------");
    }

    private void print(PrintStream outStream, int indent) {
        for (int i = 0; i < indent; ++i) {
            outStream.print("  ");
        }
        outStream.println(this);
        for (TreeNode child : this.getChildren()) {
            child.print(outStream, indent + 1);
        }
    }
}

