/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.nodes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.nodes.Subrule;
import com.github.sulir.edigen.nodes.TreeNode;
import java.util.regex.Pattern;

public class Variant
extends TreeNode {
    private static final Pattern LEADING_DIGITS = Pattern.compile("\\d.*");
    private static final Pattern NON_WORD = Pattern.compile("\\W");
    private ReturnType returnType = ReturnType.NOTHING;
    private String returnString;
    private Subrule returnSubrule;

    public String getReturnString() {
        if (this.returnType == ReturnType.STRING) {
            return this.returnString;
        }
        return null;
    }

    public void setReturnString(String returnString) {
        this.returnType = ReturnType.STRING;
        this.returnString = returnString;
    }

    public Subrule getReturnSubrule() {
        if (this.returnType == ReturnType.SUBRULE) {
            return this.returnSubrule;
        }
        return null;
    }

    public void setReturnSubrule(Subrule returnRule) {
        this.returnType = ReturnType.SUBRULE;
        this.returnSubrule = returnRule;
    }

    public boolean returns() {
        return this.returnType != ReturnType.NOTHING;
    }

    public String getFieldName() {
        if (this.returnType == ReturnType.STRING) {
            return this.makeIdentifierName(this.returnString);
        }
        return null;
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Variant");
        if (this.returnType == ReturnType.STRING) {
            result.append(": return \"").append(this.returnString).append('\"');
        } else if (this.returnType == ReturnType.SUBRULE) {
            result.append(": return ").append(this.returnSubrule);
        }
        return result.toString();
    }

    private String makeIdentifierName(String string) {
        if (LEADING_DIGITS.matcher(string = string.trim().toUpperCase()).matches()) {
            string = '_' + string;
        }
        string = string.replace(' ', '_');
        return NON_WORD.matcher(string).replaceAll("_");
    }

    private static enum ReturnType {
        NOTHING,
        STRING,
        SUBRULE;

    }
}

