/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.passes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.misc.BitSequence;
import com.github.sulir.edigen.nodes.Mask;
import com.github.sulir.edigen.nodes.Pattern;
import com.github.sulir.edigen.nodes.Rule;
import com.github.sulir.edigen.nodes.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class DetectAmbiguousVisitor
extends Visitor {
    private static final String MESSAGE = "Ambiguity detected in rule \"%s\"";
    private Rule currentRule;
    private final List<Mask> masks = new ArrayList<Mask>();

    @Override
    public void visit(Rule rule) throws SemanticException {
        this.currentRule = rule;
        this.detectPath(rule);
        this.traverseSubtrees(rule);
    }

    @Override
    public void visit(Mask mask) {
        this.masks.add(mask);
    }

    @Override
    public void visit(Pattern pattern) throws SemanticException {
        this.detectVariant(pattern);
        this.detectPath(pattern);
        this.traverseSubtrees(pattern);
    }

    private void detectPath(TreeNode node) throws SemanticException {
        this.masks.clear();
        node.acceptChildren(this);
        int maskCount = this.masks.size();
        int firstMaskIndex = 0;
        for (Mask mask1 : this.masks) {
            for (Mask mask2 : this.masks.subList(++firstMaskIndex, maskCount)) {
                Mask commonMask = mask1.and(mask2);
                for (TreeNode pattern1 : mask1.getChildren()) {
                    for (TreeNode pattern2 : mask2.getChildren()) {
                        if (!this.isAmbiguous((Pattern)pattern1, (Pattern)pattern2, commonMask)) continue;
                        String message = String.format(MESSAGE, this.currentRule.getLabel()) + ": " + pattern1 + ", " + pattern2 + " (" + commonMask + ")";
                        throw new SemanticException(message, this.currentRule);
                    }
                }
            }
        }
    }

    private boolean isAmbiguous(Pattern pattern1, Pattern pattern2, Mask commonMask) {
        BitSequence commonPattern1 = pattern1.and(commonMask).getBits();
        BitSequence commonPattern2 = pattern2.and(commonMask).getBits();
        return commonPattern1.equals(commonPattern2);
    }

    private void traverseSubtrees(TreeNode node) throws SemanticException {
        for (TreeNode child : node.getChildren()) {
            for (TreeNode subchild : child.getChildren()) {
                subchild.accept(this);
            }
        }
    }

    private void detectVariant(Pattern pattern) throws SemanticException {
        if (pattern.childCount() > 1) {
            throw new SemanticException(String.format(MESSAGE, this.currentRule.getLabel()) + ": " + pattern.toString(), this.currentRule);
        }
    }
}

