/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.passes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.misc.BitSequence;
import com.github.sulir.edigen.nodes.Mask;
import com.github.sulir.edigen.nodes.Pattern;
import com.github.sulir.edigen.nodes.Rule;
import com.github.sulir.edigen.nodes.TreeNode;

public class MoveMasksVisitor
extends Visitor {
    @Override
    public void visit(Rule rule) throws SemanticException {
        this.moveMasks(rule);
    }

    @Override
    public void visit(Pattern pattern) throws SemanticException {
        this.moveMasks(pattern);
    }

    private void moveMasks(TreeNode node) throws SemanticException {
        TreeNode firstMask = null;
        Pattern defaultPattern = new Pattern(new BitSequence());
        for (TreeNode child : node.getChildren()) {
            if (!(child instanceof Mask)) continue;
            if (firstMask == null) {
                firstMask = child;
                continue;
            }
            child.remove();
            defaultPattern.addChild(child);
        }
        if (defaultPattern.childCount() != 0 && firstMask != null) {
            firstMask.addChild(defaultPattern);
        }
        node.acceptChildren(this);
    }
}

