/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.passes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.nodes.Mask;
import com.github.sulir.edigen.nodes.Pattern;
import com.github.sulir.edigen.nodes.Rule;
import com.github.sulir.edigen.nodes.TreeNode;
import com.github.sulir.edigen.nodes.Variant;

public class MoveVariantsVisitor
extends Visitor {
    private Variant currentVariant;
    private Mask topMask;

    @Override
    public void visit(Rule rule) throws SemanticException {
        for (TreeNode child : rule.getChildren()) {
            child.accept(this);
            if (this.topMask == null) continue;
            rule.addChild(this.topMask);
        }
    }

    @Override
    public void visit(Variant variant) throws SemanticException {
        this.currentVariant = variant;
        this.topMask = null;
        TreeNode parent = variant.getParent();
        variant.remove();
        variant.acceptChildren(this);
        if (this.topMask == null) {
            parent.addChild(variant);
        }
    }

    @Override
    public void visit(Mask mask) throws SemanticException {
        if (this.topMask == null) {
            this.topMask = mask;
            mask.remove();
        }
        mask.acceptChildren(this);
    }

    @Override
    public void visit(Pattern pattern) throws SemanticException {
        if (pattern.childCount() == 0) {
            pattern.addChild(this.currentVariant);
        } else {
            pattern.acceptChildren(this);
        }
    }
}

