/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.passes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.nodes.Decoder;
import com.github.sulir.edigen.nodes.Rule;
import com.github.sulir.edigen.nodes.Subrule;
import com.github.sulir.edigen.nodes.TreeNode;
import com.github.sulir.edigen.nodes.Value;
import com.github.sulir.edigen.nodes.Variant;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResolveNamesVisitor
extends Visitor {
    private final Map<String, Rule> rules = new LinkedHashMap<String, Rule>();
    private final Set<String> ruleFieldNames = new LinkedHashSet<String>();
    private String searchedSubrule;
    private Subrule foundSubrule;

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        decoder.acceptChildren(this);
        for (TreeNode rule : decoder.getChildren()) {
            rule.acceptChildren(this);
        }
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        for (String name : rule.getNames()) {
            if (!this.rules.containsKey(name)) {
                this.rules.put(name, rule);
                String field = rule.getFieldName(name);
                if (!this.ruleFieldNames.contains(field)) {
                    this.ruleFieldNames.add(field);
                    continue;
                }
                throw new SemanticException("Rule field \"" + field + "\" is generated multiple times", rule);
            }
            throw new SemanticException("Rule \"" + name + "\" is defined multiple times", rule);
        }
    }

    @Override
    public void visit(Variant variant) throws SemanticException {
        this.searchedSubrule = variant.getReturnSubrule() == null ? null : variant.getReturnSubrule().getName();
        this.foundSubrule = null;
        variant.acceptChildren(this);
        if (this.searchedSubrule != null) {
            if (this.foundSubrule != null) {
                variant.setReturnSubrule(this.foundSubrule);
            } else {
                throw new SemanticException("Variant returns nonexistent subrule \"" + this.searchedSubrule + '\"', variant);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(Subrule subrule) throws SemanticException {
        if (this.searchedSubrule != null && subrule.getLength() != null && subrule.getName().equals(this.searchedSubrule)) {
            if (this.foundSubrule != null) throw new SemanticException("Subrule \"" + this.searchedSubrule + "\" is present multiple times in a variant which returns it", subrule);
            this.foundSubrule = subrule;
            return;
        } else {
            Rule rule = this.rules.get(subrule.getName());
            if (rule == null) throw new SemanticException("Subrule \"" + subrule.getName() + "\" refers to a nonexistent rule", subrule);
            subrule.setRule(rule);
        }
    }

    @Override
    public void visit(Value value) throws SemanticException {
        String name = value.getName();
        Rule rule = this.rules.get(name);
        if (rule == null) {
            throw new SemanticException("Disassembler value \"" + name + "\" refers to a nonexistent rule", value);
        }
        value.setRule(rule);
    }
}

