/*
 * Decompiled with CFR 0.152.
 */
package com.github.sulir.edigen.passes;

import com.github.sulir.edigen.SemanticException;
import com.github.sulir.edigen.Visitor;
import com.github.sulir.edigen.misc.BitSequence;
import com.github.sulir.edigen.nodes.Mask;
import com.github.sulir.edigen.nodes.Pattern;
import com.github.sulir.edigen.nodes.TreeNode;
import com.github.sulir.edigen.nodes.Variant;

public class SplitVisitor
extends Visitor {
    private static final int BITS_PER_PIECE = 32;
    private BitSequence maskBits;
    private BitSequence patternBits;

    @Override
    public void visit(Variant variant) throws SemanticException {
        variant.acceptChildren(this);
        BitSequence[] masks = this.maskBits.split(32);
        BitSequence[] patterns = this.patternBits.split(32);
        TreeNode parent = variant;
        for (int i = 0; i < masks.length; ++i) {
            Mask mask = new Mask(masks[i]);
            mask.setStart(i * 32);
            Pattern pattern = new Pattern(patterns[i]);
            parent.addChild(mask);
            mask.addChild(pattern);
            parent = pattern;
        }
    }

    @Override
    public void visit(Mask mask) {
        this.maskBits = mask.getBits();
        mask.remove();
    }

    @Override
    public void visit(Pattern pattern) {
        this.patternBits = pattern.getBits();
        pattern.remove();
    }
}

