/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Config;
import com.github.susom.database.ConfigFrom;
import com.github.susom.database.ConfigImpl;
import com.github.susom.database.ConfigStrings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFromImpl
implements ConfigFrom {
    private static final Logger log = LoggerFactory.getLogger(ConfigFromImpl.class);
    private List<Config> searchPath = new ArrayList<Config>();

    public ConfigFromImpl() {
    }

    public ConfigFromImpl(Config first) {
        this.searchPath.add(first);
    }

    @Override
    public ConfigFrom custom(ConfigStrings keyValueLookup) {
        this.searchPath.add(new ConfigImpl(keyValueLookup));
        return this;
    }

    @Override
    public ConfigFrom value(String key, String value) {
        return this.custom(k -> k.equals(key) ? value : null);
    }

    @Override
    public ConfigFrom config(Config config) {
        this.searchPath.add(config);
        return this;
    }

    @Override
    public ConfigFrom config(ConfigFrom config) {
        return this.config(config.get());
    }

    @Override
    public ConfigFrom systemProperties() {
        return this.custom(System::getProperty);
    }

    @Override
    public ConfigFrom properties(Properties properties) {
        return this.custom(properties::getProperty);
    }

    @Override
    public ConfigFrom propertyFile(String ... filenames) {
        return this.propertyFile(Charset.defaultCharset().newDecoder(), filenames);
    }

    @Override
    public ConfigFrom propertyFile(CharsetDecoder decoder, String ... filenames) {
        for (String filename : filenames) {
            if (filename == null) continue;
            this.propertyFile(decoder, new File(filename));
        }
        return this;
    }

    @Override
    public ConfigFrom propertyFile(File ... files) {
        return this.propertyFile(Charset.defaultCharset().newDecoder(), files);
    }

    @Override
    public ConfigFrom propertyFile(CharsetDecoder decoder, File ... files) {
        for (File file : files) {
            if (file == null) continue;
            try {
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(file), decoder));
                this.searchPath.add(new ConfigImpl(properties::getProperty));
                if (!log.isTraceEnabled()) continue;
                log.trace("Using properties from file: " + file.getAbsolutePath());
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Unable to load properties from file: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        return this;
    }

    @Override
    public ConfigFrom includePrefix(String ... prefixes) {
        return new ConfigFromImpl(new ConfigImpl(key -> {
            for (String prefix : prefixes) {
                if (!key.startsWith(prefix)) continue;
                return this.lookup(key);
            }
            return null;
        }));
    }

    @Override
    public ConfigFrom includeRegex(String regex) {
        return new ConfigFromImpl(new ConfigImpl(key -> {
            if (key.matches(regex)) {
                return this.lookup(key);
            }
            return null;
        }));
    }

    @Override
    public ConfigFrom excludePrefix(String ... prefixes) {
        return new ConfigFromImpl(new ConfigImpl(key -> {
            for (String prefix : prefixes) {
                if (!key.startsWith(prefix)) continue;
                return null;
            }
            return this.lookup(key);
        }));
    }

    @Override
    public ConfigFrom excludeRegex(String regex) {
        return new ConfigFromImpl(new ConfigImpl(key -> {
            if (key.matches(regex)) {
                return null;
            }
            return this.lookup(key);
        }));
    }

    @Override
    public ConfigFrom removePrefix(String ... prefixes) {
        return new ConfigFromImpl(new ConfigImpl(key -> {
            String value = this.lookup(key);
            if (value != null) {
                return value;
            }
            for (String prefix : prefixes) {
                value = this.lookup(prefix + key);
                if (value == null) continue;
                return value;
            }
            return null;
        }));
    }

    @Override
    public ConfigFrom addPrefix(String prefix) {
        return new ConfigFromImpl(new ConfigImpl(key -> {
            if (key.startsWith(prefix)) {
                return this.lookup(key.substring(prefix.length()));
            }
            return null;
        }));
    }

    @Override
    public Config get() {
        return new ConfigImpl(this::lookup);
    }

    private String lookup(String key) {
        for (Config config : this.searchPath) {
            String value = config.getString(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

